% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.R
\name{chat_clear}
\alias{chat_clear}
\title{Clear all messages from a chat control}
\usage{
chat_clear(id, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{The ID of the chat element}

\item{session}{The Shiny session object}
}
\description{
Clear all messages from a chat control
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(shiny)
library(bslib)

ui <- page_fillable(
  chat_ui("chat", fill = TRUE),
  actionButton("clear", "Clear chat")
)

server <- function(input, output, session) {
  observeEvent(input$clear, {
    chat_clear("chat")
  })

  observeEvent(input$chat_user_input, {
    response <- paste0("You said: ", input$chat_user_input)
    chat_append("chat", response)
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
