% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-bar.R
\name{manual-progressbar}
\alias{manual-progressbar}
\alias{use_busy_bar}
\alias{update_busy_bar}
\title{Manual progress bar}
\usage{
use_busy_bar(color = "#112446", centered = FALSE)

update_busy_bar(value, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{color}{Progress bar color.}

\item{centered}{Center the progress bar or not.}

\item{value}{The new value for the progress bar.}

\item{session}{Shiny session.}
}
\description{
Declare \code{use_busy_bar} in your UI and update value server-side with \code{update_busy_bar}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinybusy)

  ui <- fluidPage(
    tags$h2("Manual nanobar"),
    use_busy_bar(),
    actionButton(inputId = "go", label = "Go")
  )

  server <- function(input, output, session) {

    observeEvent(input$go, {
      update_busy_bar(10)
      Sys.sleep(1)
      update_busy_bar(20)
      Sys.sleep(1)
      update_busy_bar(40)
      Sys.sleep(1)
      update_busy_bar(60)
      Sys.sleep(1)
      update_busy_bar(80)
      Sys.sleep(1)
      update_busy_bar(100)
    })

  }

  shinyApp(ui, server)
}
}
