% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-textaddon.R
\name{textInputAddon}
\alias{textInputAddon}
\title{Text with Add-on Input Control}
\usage{
textInputAddon(inputId, label, value = "", placeholder = NULL, addon,
  width = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value..}

\item{placeholder}{A character string giving the user a hint as to what can be entered into the control.}

\item{addon}{An icon tag, created by \link[shiny]{icon}.}

\item{width}{The width of the input : 'auto', 'fit', '100px', '75\%'}
}
\value{
A switch control that can be added to a UI definition.
}
\description{
Create text field with add-on.
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {
shinyApp(
  ui = fluidPage(
    textInputAddon(inputId = "id", label = "Label", placeholder = "Username", addon = icon("at")),
    verbatimTextOutput(outputId = "out")
  ),
  server = function(input, output) {
    output$out <- renderPrint({
      input$id
    })
  }
)
}
}

}
