% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-validate-inputs.R
\name{validateF7Input}
\alias{validateF7Input}
\title{Framework7 input validation}
\usage{
validateF7Input(
  inputId,
  info = NULL,
  pattern = NULL,
  error = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Input to validate.}

\item{info}{Additional text to display below the input field.}

\item{pattern}{Pattern for validation. Regex.}

\item{error}{Error text.}

\item{session}{Shiny session object.}
}
\description{
\code{validateF7Input} is a function to validate a given shinyMobile input.
}
\note{
Only works for \link{f7Text}, \link{f7Password} and \link{f7TextArea}.
See more at \url{https://framework7.io/docs/inputs.html}.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Validate inputs",
    f7SingleLayout(
      navbar = f7Navbar(title = "validateF7Input"),
      f7Text(
        inputId = "caption",
        label = "Caption",
        value = "Data Summary"
      ),
      verbatimTextOutput("value"),
      hr(),
      f7Text(
        inputId = "caption2",
        label = "Enter a number",
        value = 1
      ),
      hr(),
      f7Password(
        inputId = "password",
        label = "Password"
      )
    )
  ),
  server = function(input, output, session) {
    observe({
      validateF7Input(inputId = "caption", info = "Whatever")
      validateF7Input(
        inputId = "caption2",
        pattern = "[0-9]*",
        error = "Only numbers please!"
      )
      validateF7Input(
        inputId = "password",
        pattern = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\\\d)[a-zA-Z\\\\d]{8,}$",
        error = "Password must contain at least one
        number and one uppercase and lowercase letter,
        and at least 8 or more characters"
      )
    })

    output$value <- renderPrint({
      input$caption
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
