% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Panel.R
\name{f7Panel}
\alias{f7Panel}
\alias{updateF7Panel}
\title{Framework7 panel}
\usage{
f7Panel(
  ...,
  id = NULL,
  title = NULL,
  side = c("left", "right"),
  theme = deprecated(),
  effect = c("reveal", "cover", "push", "floating"),
  resizable = FALSE,
  options = list()
)

updateF7Panel(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{Panel content. Slot for \link{f7PanelMenu}, if used as a sidebar.}

\item{id}{Panel unique id.}

\item{title}{Panel title.}

\item{side}{Panel side: "left" or "right".}

\item{theme}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
removed from Framework7.}

\item{effect}{Whether the panel should behave
when opened: "cover", "reveal", "floating" or "push".}

\item{resizable}{Whether to enable panel resize. FALSE by default.}

\item{options}{Other panel options.
See \url{https://framework7.io/docs/panel#panel-parameters}.}

\item{session}{Shiny session object.}
}
\description{
\code{f7Panel} is a sidebar element. It may be used as a simple
sidebar or as a container for \link{f7PanelMenu} in case of
\link{f7SplitLayout}.

\code{updateF7Panel} toggles an \link{f7Panel} from the server.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Panels",
    options = list(dark = FALSE),
    f7SingleLayout(
      navbar = f7Navbar(
        title = "f7Panel",
        leftPanel = TRUE,
        rightPanel = TRUE
      ),
      panels = tagList(
        f7Panel(
          id = "mypanel1",
          side = "left",
          effect = "push",
          title = "Left panel",
          resizable = TRUE,
          f7Block("A panel with push effect"),
          f7PanelMenu(
            id = "panelmenu",
            f7PanelItem(
              tabName = "tab1",
              title = "Tab 1",
              icon = f7Icon("envelope"),
              active = TRUE
            ),
            f7PanelItem(
              tabName = "tab2",
              title = "Tab 2",
              icon = f7Icon("house")
            )
          )
        ),
        f7Panel(
          id = "mypanel2",
          side = "right",
          effect = "floating",
          title = "Right panel",
          f7Block(
            "A panel with cover effect"
          ),
          options = list(swipe = TRUE)
        )
      ),
      toolbar = f7Toolbar(
        position = "bottom",
        icons = TRUE,
        f7Link(label = "Link 1", href = "https://www.google.com"),
        f7Link(label = "Link 2", href = "https://www.google.com")
      ),
      # main content
      f7Block(
        f7Button(inputId = "toggle", "Toggle panel 1")
      )
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$mypanel2, {
      state <- if (input$mypanel2) "open" else "closed"

      f7Toast(
        text = paste0("Right panel is ", state),
        position = "center",
        closeTimeout = 1000,
        closeButton = FALSE
      )
    })

    observeEvent(input$toggle, {
      updateF7Panel(id = "mypanel1")
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
