% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Messages.R
\name{f7Messages}
\alias{f7Messages}
\alias{f7Message}
\alias{updateF7Messages}
\title{Framework7 messages container}
\usage{
f7Messages(
  id,
  title = NULL,
  autoLayout = TRUE,
  newMessagesFirst = FALSE,
  scrollMessages = TRUE,
  scrollMessagesOnEdge = TRUE
)

f7Message(
  text,
  name,
  type = c("sent", "received"),
  header = NULL,
  footer = NULL,
  avatar = NULL,
  textHeader = NULL,
  textFooter = NULL,
  image = NULL,
  imageSrc = NULL,
  cssClass = NULL
)

updateF7Messages(
  id,
  messages,
  showTyping = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{Reference to \link{f7Messages} container.}

\item{title}{Optional messages title.}

\item{autoLayout}{Enable Auto Layout to add all required additional classes
automatically based on passed conditions.}

\item{newMessagesFirst}{Enable if you want to use new messages on top,
instead of having them on bottom.}

\item{scrollMessages}{Enable/disable messages auto scrolling when adding new message.}

\item{scrollMessagesOnEdge}{If enabled then messages auto scrolling will happen only
when user is on top/bottom of the messages view.}

\item{text}{Message text.}

\item{name}{Sender name.}

\item{type}{Message type - sent or received.}

\item{header}{Single message header.}

\item{footer}{Single message footer.}

\item{avatar}{Sender avatar URL string.}

\item{textHeader}{Message text header.}

\item{textFooter}{Message text footer.}

\item{image}{Message image HTML string, e.g. \verb{<img src="path/to/image">}. Can be used instead of imageSrc parameter.}

\item{imageSrc}{Message image URL string. Can be used instead of image parameter.}

\item{cssClass}{Additional CSS class to set on message HTML element.}

\item{messages}{List of \link{f7Message}.}

\item{showTyping}{Show typing when a new message comes. Default to FALSE.
Does not work yet...}

\item{session}{Shiny session object}
}
\description{
\code{f7Messages} is an empty container targeted by \link{updateF7Messages}
to include multiple \link{f7Message}.

\code{f7Message} creates a message item to be inserted in
\link{f7Messages} with \link{updateF7Messages}.

\code{updateF7Messages} add messages to a \link{f7Messages} container.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Messages",
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Messages",
        hairline = FALSE
      ),
      toolbar = f7MessageBar(inputId = "mymessagebar", placeholder = "Message"),
      # main content
      f7Messages(id = "mymessages", title = "My message")
    )
  ),
  server = function(input, output, session) {
    # Send a message
    observeEvent(input[["mymessagebar-send"]], {
      updateF7Messages(
        id = "mymessages",
        list(
          f7Message(
            text = input$mymessagebar,
            name = "David",
            type = "sent",
            header = "Message Header",
            footer = "Message Footer",
            textHeader = "Text Header",
            textFooter = "text Footer",
            avatar = "https://cdn.framework7.io/placeholder/people-100x100-7.jpg"
          )
        )
      )
    })

    # Receive a message
    observeEvent(TRUE, {
      updateF7Messages(
        id = "mymessages",
        showTyping = FALSE, # DOES NOT WORK YET WHEN TRUE ...
        list(
          f7Message(
            text = "Some message",
            name = "Victor",
            type = "received",
            avatar = "https://cdn.framework7.io/placeholder/people-100x100-9.jpg"
          )
        )
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
