% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7TapHold.R
\name{f7TapHold}
\alias{f7TapHold}
\title{Framework7 tapHold module}
\usage{
f7TapHold(target, callback, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{target}{Element to apply the tapHold event on. Must be a jQuery selector,
such as "#id" or ".class", ".class1, .class2", "a"...}

\item{callback}{Javascript callback.}

\item{session}{Shiny session object.}
}
\description{
\link{f7TapHold} is triggered after long press on an element, from the server.
}
\examples{
if (interactive()) {
library(shiny)
library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "Taphold",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7TapHold"),
       f7Button(inputId = "pressme", label = "Press me")
     )
   ),
   server = function(input, output, session) {
    observe({
      f7TapHold(
       target = "#pressme",
       callback = "app.dialog.alert('Tap hold fired!');"
      )
    })
   }
 )
}
}
