% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Radio}
\alias{f7Radio}
\title{Create an f7 radio button input}
\usage{
f7Radio(inputId, label, choices = NULL, selected = NULL)
}
\arguments{
\item{inputId}{Radio input id.}

\item{label}{Radio label}

\item{choices}{List of choices.}

\item{selected}{Selected element. NULL by default.}
}
\description{
Create an f7 radio button input
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Radio"),
     f7Radio(
      inputId = "radio",
      label = "Choose a fruit:",
      choices = c("banana", "apple", "peach"),
      selected = "apple"
     ),
     plotOutput("plot")
    )
   ),
   server = function(input, output) {
    output$plot <- renderPlot({
     if (input$radio == "apple") hist(mtcars[, "mpg"])
    })
   }
 )
}
}
