% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Popover.R
\name{f7Popover}
\alias{f7Popover}
\title{Create a framework 7 popover}
\usage{
f7Popover(targetId, content, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{targetId}{Target to put the popover on.}

\item{content}{Popover content.}

\item{session}{shiny session.}
}
\description{
\link{f7Popover} has to be used in an oberve
or observeEvent context. Only works for input elements!
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "f7Popover",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7Popover"),
       f7PopoverTarget(
         f7Button(
           inputId = "goButton",
           "Go!"
         ),
         targetId = "test"
       ),
       br(),
       br(),
       f7PopoverTarget(
         f7Slider(
           inputId = "slider",
           label = "Value",
           value = 10,
           min = 0,
           max = 20
         ),
         targetId = "test2"
       )
     )
   ),
   server = function(input, output, session) {
     observe({
       f7Popover(
         targetId = "test",
         content = "This is a f7Button",
         session
       )
     })

     observe({
       f7Popover(
         targetId = "test2",
         content = "This is a f7Slider",
         session
       )
     })
   }
 )
}
}
