% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-action.R
\name{actionButton}
\alias{actionButton}
\alias{actionLink}
\title{Action button/link}
\usage{
actionButton(inputId, label, icon = NULL, width = NULL, ...)

actionLink(inputId, label, icon = NULL, ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{The contents of the button or link--usually a text label, but
you could also use any other HTML, like an image.}

\item{icon}{An optional \code{\link[=icon]{icon()}} to appear on the button.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[=validateCssUnit]{validateCssUnit()}}.}

\item{...}{Named attributes to be applied to the button or link.}
}
\description{
Creates an action button or link whose value is initially zero, and increments by one
each time it is pressed.
}
\section{Server value}{

An integer of class \code{"shinyActionButtonValue"}. This class differs from
ordinary integers in that a value of 0 is considered "falsy".
This implies two things:
\itemize{
\item Event handlers (e.g., \code{\link[=observeEvent]{observeEvent()}}, \code{\link[=eventReactive]{eventReactive()}}) won't execute on initial load.
\item Input validation (e.g., \code{\link[=req]{req()}}, \code{\link[=need]{need()}}) will fail on initial load.
}
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  sliderInput("obs", "Number of observations", 0, 1000, 500),
  actionButton("goButton", "Go!"),
  plotOutput("distPlot")
)

server <- function(input, output) {
  output$distPlot <- renderPlot({
    # Take a dependency on input$goButton. This will run once initially,
    # because the value changes from NULL to 0.
    input$goButton

    # Use isolate() to avoid dependency on input$obs
    dist <- isolate(rnorm(input$obs))
    hist(dist)
  })
}

shinyApp(ui, server)

}

}
\seealso{
\code{\link[=observeEvent]{observeEvent()}} and \code{\link[=eventReactive]{eventReactive()}}

Other input elements: \code{\link{checkboxGroupInput}},
  \code{\link{checkboxInput}}, \code{\link{dateInput}},
  \code{\link{dateRangeInput}}, \code{\link{fileInput}},
  \code{\link{numericInput}}, \code{\link{passwordInput}},
  \code{\link{radioButtons}}, \code{\link{selectInput}},
  \code{\link{sliderInput}}, \code{\link{submitButton}},
  \code{\link{textAreaInput}}, \code{\link{textInput}},
  \code{\link{varSelectInput}}
}
\concept{input elements}
