% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap-layout.R
\name{splitLayout}
\alias{splitLayout}
\title{Split layout}
\usage{
splitLayout(..., cellWidths = NULL, cellArgs = list())
}
\arguments{
\item{...}{Unnamed arguments will become child elements of the layout. Named
arguments will become HTML attributes on the outermost tag.}

\item{cellWidths}{Character or numeric vector indicating the widths of the
individual cells. Recycling will be used if needed. Character values will
be interpreted as CSS lengths (see \code{\link{validateCssUnit}}), numeric
values as pixels.}

\item{cellArgs}{Any additional attributes that should be used for each cell
of the layout.}
}
\description{
Lays out elements horizontally, dividing the available horizontal space into
equal parts (by default).
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
options(device.ask.default = FALSE)

# Server code used for all examples
server <- function(input, output) {
  output$plot1 <- renderPlot(plot(cars))
  output$plot2 <- renderPlot(plot(pressure))
  output$plot3 <- renderPlot(plot(AirPassengers))
}

# Equal sizing
ui <- splitLayout(
  plotOutput("plot1"),
  plotOutput("plot2")
)
shinyApp(ui, server)

# Custom widths
ui <- splitLayout(cellWidths = c("25\%", "75\%"),
  plotOutput("plot1"),
  plotOutput("plot2")
)
shinyApp(ui, server)

# All cells at 300 pixels wide, with cell padding
# and a border around everything
ui <- splitLayout(
  style = "border: 1px solid silver;",
  cellWidths = 300,
  cellArgs = list(style = "padding: 6px"),
  plotOutput("plot1"),
  plotOutput("plot2"),
  plotOutput("plot3")
)
shinyApp(ui, server)
}
}
