% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{Dropdown}
\alias{Dropdown}
\alias{Dropdown.shinyInput}
\alias{updateDropdown.shinyInput}
\title{Dropdown}
\usage{
Dropdown(...)

Dropdown.shinyInput(inputId, ..., value = defaultValue)

updateDropdown.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
A dropdown menu is a list in which the selected item is always visible while other items are visible on demand by clicking a dropdown button.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Dropdown}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ defaultSelectedKeys }} {\code{string[] | number[]} \cr Keys that will be initially used to set selected items. This prop is only used when \code{multiSelect} is true (use \code{defaultSelectedKey} for single select). Mutually exclusive with \code{selectedKeys}.}
\item {\bold{ dropdownWidth }} {\code{number} \cr Custom width for dropdown. If value is 0, width of the input field is used.}
\item {\bold{ isDisabled }} {\code{boolean} \cr Deprecated at v0.52.0, use \code{disabled} instead.}
\item {\bold{ keytipProps }} {\code{IKeytipProps} \cr Optional keytip for this dropdown}
\item {\bold{ multiSelectDelimiter }} {\code{string} \cr When multiple items are selected, this will be used to separate values in the dropdown input.}
\item {\bold{ notifyOnReselect }} {\code{boolean} \cr If true, \code{onChange} will still be called when an already-selected item is clicked again in single select mode. (Normally it would not be called in this case.)}
\item {\bold{ onChange }} {\verb{(event: React.FormEvent<HTMLDivElement>, option?: IDropdownOption, index?: number) => void} \cr Callback for when the selected option changes.}
\item {\bold{ onChanged }} {\verb{(option: IDropdownOption, index?: number) => void} \cr }
\item {\bold{ onRenderCaretDown }} {\verb{IRenderFunction<IDropdownProps>} \cr Custom renderer for chevron icon}
\item {\bold{ onRenderLabel }} {\verb{IRenderFunction<IDropdownProps>} \cr Custom renderer for the label.}
\item {\bold{ onRenderPlaceholder }} {\verb{IRenderFunction<IDropdownProps>} \cr Custom renderer for placeholder text}
\item {\bold{ onRenderPlaceHolder }} {\verb{IRenderFunction<IDropdownProps>} \cr Custom renderer for placeholder text}
\item {\bold{ onRenderTitle }} {\verb{IRenderFunction<IDropdownOption[]>} \cr Custom renderer for selected option displayed in input}
\item {\bold{ options }} {\code{IDropdownOption[]} \cr Options for the dropdown. If using \code{defaultSelectedKey} or \code{defaultSelectedKeys}, options must be pure for correct behavior.}
\item {\bold{ placeHolder }} {\code{string} \cr Input placeholder text. Displayed until an option is selected.}
\item {\bold{ responsiveMode }} {\code{ResponsiveMode} \cr By default, the dropdown will render the standard way for screen sizes \code{large} and above, or in a panel on \code{small} and \code{medium} screens. Manually set this prop to override this behavior.}
\item {\bold{ selectedKeys }} {\code{string[] | number[] | null} \cr Keys of the selected items, only used when \code{multiSelect} is true (use \code{selectedKey} for single select). If you provide this, you must maintain selection state by observing onChange events and passing a new prop value in when changed. Passing null will clear the selection. Mutually exclusive with \code{defaultSelectedKeys}.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IDropdownStyleProps, IDropdownStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by higher order component.}
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Use a dropdown list when there are multiple choices that can be collapsed under one title, if the list of items is too long, or when space is constrained.
\item Use a dropdown list when the selected option is more important than the alternatives (in contrast to radio buttons where all the choices are visible, putting equal emphasis on all options).
}
}

\subsection{Content}{
\itemize{
\item Use sentence-style capitalization—only capitalize the first word. For more info, see \href{https://docs.microsoft.com/style-guide/capitalization}{Capitalization} in the Microsoft Writing Style Guide.
\item The dropdown list label should describe what can be found in the menu.
\item Use shortened statements or single words as list options.
\item If there isn't a default option, use "Select an option" as placeholder text.
\item If "None" is an option, include it.
\item Write the choices using parallel construction. For example, start with the same part of speech or verb tense.
}
}
}

\examples{
library(shiny.fluent)

if (interactive()) {
  options <- list(
    list(key = "A", text = "Option A"),
    list(key = "B", text = "Option B"),
    list(key = "C", text = "Option C")
  )

  shinyApp(
    ui = div(
      Dropdown.shinyInput("dropdown", value = "A", options = options),
      textOutput("dropdownValue")
    ),
    server = function(input, output) {
      output$dropdownValue <- renderText({
        sprintf("Value: \%s", input$dropdown)
      })
    }
  )
}
}
