% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{VerticalDivider}
\alias{VerticalDivider}
\alias{Divider}
\title{Divider}
\usage{
VerticalDivider(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
A Divider is a line that is used to visually differentiate different parts of a UI. They are commonly used in headers and command bars. This divider automatically center algins itself within the parent container and can be customized to be shown in different heights and colors.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Divider}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\section{Best practices}{
Use a divider component to show a sectional or continuity change in the content between two blocks of information. The spacing around the divider is generally determined by the content surrounding it.

There are two recommended divider color combinations:
\enumerate{
\item #C8C8C8/neutralTertiaryAlt divider when used within an #F4F4F4/neutralLighter layout
\item #EAEAEA/neutralLight divider when used within an #FFFFFF/white layout
}
}

