% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{EnsemblePredictions}
\alias{EnsemblePredictions}
\title{Predictions from ensemble model}
\usage{
EnsemblePredictions(ensemble, xdata, ...)
}
\arguments{
\item{ensemble}{output of \code{\link{Ensemble}}.}

\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{...}{additional parameters passed to \code{\link[stats]{predict}}.}
}
\value{
A matrix of predictions computed from the observations in
  \code{xdata}.
}
\description{
Makes predictions using an ensemble model created from
\code{\link{VariableSelection}} outputs. For each observation in
\code{xdata}, the predictions are calculated as the average predicted values
obtained for that observation over the \code{K} models fitted in calibrated
stability selection.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 1000, pk = 50, family = "gaussian")

# Training/test split
ids <- Split(data = simul$ydata, tau = c(0.8, 0.2))
stab <- VariableSelection(
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ]
)

# Constructing the ensemble model
ensemble <- Ensemble(
  stability = stab,
  xdata = simul$xdata[ids[[1]], ],
  ydata = simul$ydata[ids[[1]], ]
)

# Making predictions
yhat <- EnsemblePredictions(
  ensemble = ensemble,
  xdata = simul$xdata[ids[[2]], ]
)

# Calculating Q-squared
cor(simul$ydata[ids[[2]], ], yhat)^2
}
}
\seealso{
\code{\link{predict.variable_selection}}

Other ensemble model functions: 
\code{\link{Ensemble}()}
}
\concept{ensemble model functions}
