% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_models.R
\name{DBSCANClustering}
\alias{DBSCANClustering}
\title{(Weighted) density-based clustering}
\usage{
DBSCANClustering(
  xdata,
  nc = NULL,
  eps = NULL,
  Lambda = NULL,
  distance = "euclidean",
  scale = TRUE,
  ...
)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.}

\item{nc}{matrix of parameters controlling the number of clusters in the
underlying algorithm specified in \code{implementation}. If \code{nc} is
not provided, it is set to \code{seq(1, tau*nrow(xdata))}.}

\item{eps}{radius in density-based clustering, see
\code{\link[dbscan]{dbscan}}.}

\item{Lambda}{vector of penalty parameters (see argument \code{lambda} in
\code{\link[rCOSA]{cosa2}}). Unweighted distance matrices are used if
\code{Lambda=NULL}.}

\item{distance}{character string indicating the type of distance to use. If
\code{Lambda=NULL}, possible values include \code{"euclidean"},
\code{"maximum"}, \code{"canberra"}, \code{"binary"}, and
\code{"minkowski"} (see argument \code{method} in
\code{\link[stats]{dist}}).  Otherwise, possible values include
\code{"euclidean"} (\code{pwr=2}) or \code{"absolute"} (\code{pwr=1}) (see
argument \code{pwr} in \code{\link[rCOSA]{cosa2}}).}

\item{scale}{logical indicating if the data should be scaled to ensure that
all variables contribute equally to the clustering of the observations.}

\item{...}{additional parameters passed to \code{\link[dbscan]{dbscan}}
(except for \code{minPts} which is fixed to \code{2}),
\code{\link[stats]{dist}}, or \code{\link[rCOSA]{cosa2}}. If
\code{weighted=TRUE}, parameters \code{niter} (default to 1) and
\code{noit} (default to 100) correspond to the number of iterations in
\code{\link[rCOSA]{cosa2}} to calculate weights and may need to be
modified.}
}
\value{
A list with: \item{comembership}{an array of binary and symmetric
  co-membership matrices.} \item{weights}{a matrix of median weights by
  feature.}
}
\description{
Runs Density-Based Spatial Clustering of Applications with Noise (DBSCAN)
clustering using implementation from \code{\link[dbscan]{dbscan}}. This is
also known as the k-medoids algorithm. If \code{Lambda} is provided,
clustering is applied on the weighted distance matrix calculated using the
COSA algorithm as implemented in \code{\link[rCOSA]{cosa2}}. Otherwise,
distances are calculated using \code{\link[stats]{dist}}. This function is
not using stability.
}
\examples{

# Data simulation
set.seed(1)
simul <- SimulateClustering(n = c(10, 10), pk = 50)
plot(simul)

# DBSCAN clustering
myclust <- DBSCANClustering(
  xdata = simul$data,
  eps = seq(0, 2 * sqrt(ncol(simul$data) - 1), by = 0.1)
)

# Weighted PAM clustering (using COSA)
if (requireNamespace("rCOSA", quietly = TRUE)) {
  myclust <- DBSCANClustering(
    xdata = simul$data,
    eps = c(0.25, 0.5, 0.75),
    Lambda = c(0.2, 0.5)
  )
}
}
\references{
\insertRef{rCOSA}{sharp}

  \insertRef{COSA}{sharp}
}
\seealso{
Other clustering algorithms: 
\code{\link{GMMClustering}()},
\code{\link{HierarchicalClustering}()},
\code{\link{KMeansClustering}()},
\code{\link{PAMClustering}()}
}
\concept{clustering algorithms}
