% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_get_mask_generator_name}
\alias{vaeac_get_mask_generator_name}
\title{Function that determines which mask generator to use}
\usage{
vaeac_get_mask_generator_name(
  mask_gen_coalitions,
  mask_gen_coalitions_prob,
  masking_ratio,
  verbose
)
}
\arguments{
\item{mask_gen_coalitions}{Matrix (default is \code{NULL}). Matrix containing the coalitions that the
\code{vaeac} model will be trained on, see \code{\link[=specified_masks_mask_generator]{specified_masks_mask_generator()}}. This parameter is used internally
in \code{shapr} when we only consider a subset of coalitions, i.e., when
\code{n_coalitions} \eqn{< 2^{n_{\text{features}}}}, and for group Shapley, i.e.,
when \code{group} is specified in \code{\link[=explain]{explain()}}.}

\item{mask_gen_coalitions_prob}{Numeric array (default is \code{NULL}). Array of length equal to the height
of \code{mask_gen_coalitions} containing the probabilities of sampling the corresponding coalitions in
\code{mask_gen_coalitions}.}

\item{masking_ratio}{Numeric (default is \code{0.5}). Probability of masking a feature in the
\code{\link[=mcar_mask_generator]{mcar_mask_generator()}} (MCAR = Missing Completely At Random). The MCAR masking scheme ensures that \code{vaeac}
model can do arbitrary conditioning as all coalitions will be trained. \code{masking_ratio} will be overruled if
\code{mask_gen_coalitions} is specified.}

\item{verbose}{String vector or NULL.
Specifies the verbosity (printout detail level) through one or more of strings \code{"basic"}, \code{"progress"},
\code{"convergence"}, \code{"shapley"} and \code{"vS_details"}.
\code{"basic"} (default) displays basic information about the computation which is being performed.
\verb{"progress} displays information about where in the calculation process the function currently is.
#' \code{"convergence"} displays information on how close to convergence the Shapley value estimates are
(only when \code{iterative = TRUE}) .
\code{"shapley"} displays intermediate Shapley value estimates and standard deviations (only when \code{iterative = TRUE})
\itemize{
\item the final estimates.
\code{"vS_details"} displays information about the v_S estimates.
This is most relevant for \verb{approach \%in\% c("regression_separate", "regression_surrogate", "vaeac"}).
\code{NULL} means no printout.
Note that any combination of four strings can be used.
E.g. \code{verbose = c("basic", "vS_details")} will display basic information + details about the v(S)-estimation process.
}}
}
\value{
The function does not return anything.
}
\description{
Function that determines which mask generator to use
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
