% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgraph_clusters.R
\name{sgraph_clusters}
\alias{sgraph_clusters}
\title{Build a sgraph object colored by clusters}
\usage{
sgraph_clusters(
  igraph,
  color_map = NULL,
  label = "name",
  clusters = TRUE,
  arrows = FALSE,
  node_size = NULL,
  layout = igraph::layout_with_fr(igraph),
  ...
)
}
\arguments{
\item{igraph}{Igraph object}

\item{color_map}{Use a color mapping to select colors (enables to link the
graph with other plots) as returned by the get_color_map
function. Leave NULL for automatic colors (default).}

\item{label}{Name of the igraph attribute to use as labels}

\item{clusters}{Whether or not to use a column named clusters to color
the nodes.}

\item{arrows}{Whether or not to display arrows on directed edges.}

\item{node_size}{Passed to add_node_size function, either a numeric or an
attribute name. Default is NULL.}

\item{layout}{Output of an igraph layout (default: layout_with_fr)}

\item{...}{Passed to sigma_from_igraph}
}
\value{
Htmlwidget object
}
\description{
Wrapper function to build a sigma.js visualization of an igraph object and
color it using a 'clusters' attribute. It calls the sigma_from_igraph
function, and manages labels, node sizes, color mapping, layouts, and
optionally arrows. The clusters attribute can be also be disabled to just
use the wrapper to manage the other attributes.
}
