% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_dists.R
\name{st_nb_dists}
\alias{st_nb_dists}
\title{Calculate neighbor distances}
\usage{
st_nb_dists(x, nb, longlat = NULL)
}
\arguments{
\item{x}{an object of class \code{sfc}.}

\item{nb}{a neighbor list for example created by \code{\link[=st_contiguity]{st_contiguity()}}}

\item{longlat}{\code{TRUE} if point coordinates are longitude-latitude decimal degrees, in which case distances are measured in kilometers. See \code{?spdep::nbdists()} for more.}
}
\value{
a list where each element is a numeric vector.
}
\description{
From an nb list and point geometry, return a list of distances for each observation's neighbors list.
}
\details{
Utilizes \code{spdep::nbdists()} for distance calculation.
}
\examples{
geo <- sf::st_geometry(guerry)
nb <- st_contiguity(geo)
dists <- st_nb_dists(geo, nb)

head(dists)
}
\seealso{
Other weights: 
\code{\link{st_inverse_distance}()},
\code{\link{st_kernel_weights}()},
\code{\link{st_weights}()}
}
\concept{weights}
