% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-moran-bv-impl.R
\name{global_moran_bv}
\alias{global_moran_bv}
\title{Compute the Global Bivariate Moran's I}
\usage{
global_moran_bv(x, y, nb, wt, nsim = 99)
}
\arguments{
\item{x}{a numeric vector of same length as \code{nb}.}

\item{y}{a numeric vector of same length as \code{nb}.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{nsim}{the number of simulations to run.}
}
\value{
a named list with two elements \code{Ib} and \code{p_sim} containing the bivariate Moran's I and simulated p-value respectively.
}
\description{
Given two continuous numeric variables, calculate the bivariate Moran's I. See details for more.
}
\details{
The Global Bivariate Moran is defined as

\eqn{
I_B = \frac{\Sigma_i(\Sigma_j{w_{ij}y_j\times x_i})}{\Sigma_i{x_i^2}}
}

It is important to note that this is a measure of autocorrelation of X
with the spatial lag of Y. As such, the resultant measure may overestimate the amount of
spatial autocorrelation which may be a product of the inherent correlation of X and Y.
}
\examples{
x <- guerry_nb$crime_pers
y <- guerry_nb$wealth
nb <- guerry_nb$nb
wt <- guerry_nb$wt
global_moran_bv(x, y, nb, wt)
}
\references{
\href{https://geodacenter.github.io/workbook/5b_global_adv/lab5b.html}{Global Spatial Autocorrelation (2): Bivariate, Differential and EB Rate Moran Scatter Plot, Luc Anselin}
}
\seealso{
Other global_moran: 
\code{\link{global_moran_perm}()},
\code{\link{global_moran_test}()},
\code{\link{global_moran}()},
\code{\link{local_moran_bv}()}
}
\concept{global_moran}
