% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos}
\alias{geos}
\alias{st_boundary}
\alias{st_buffer}
\alias{st_centroid}
\alias{st_contains}
\alias{st_convex_hull}
\alias{st_covered_by}
\alias{st_covers}
\alias{st_crosses}
\alias{st_difference}
\alias{st_disjoint}
\alias{st_distance}
\alias{st_equals}
\alias{st_equals_exact}
\alias{st_intersection}
\alias{st_intersects}
\alias{st_is_simple}
\alias{st_is_valid}
\alias{st_is_within_distance}
\alias{st_merge}
\alias{st_overlaps}
\alias{st_polygonize}
\alias{st_relate}
\alias{st_segmentize}
\alias{st_simplify}
\alias{st_sym_difference}
\alias{st_touches}
\alias{st_triangulate}
\alias{st_union}
\alias{st_union_cascaded}
\alias{st_within}
\title{Geometric operations on (pairs of) simple feature geometries}
\usage{
st_is_valid(x)

st_is_simple(x)

st_distance(x, y = x)

st_relate(x, y)

st_intersects(x, y, sparse = TRUE)

st_disjoint(x, y, sparse = TRUE)

st_touches(x, y, sparse = TRUE)

st_crosses(x, y, sparse = TRUE)

st_within(x, y, sparse = TRUE)

st_contains(x, y, sparse = TRUE)

st_overlaps(x, y, sparse = TRUE)

st_equals(x, y, sparse = TRUE)

st_covers(x, y, sparse = TRUE)

st_covered_by(x, y, sparse = TRUE)

st_equals_exact(x, y, par, sparse = TRUE)

st_is_within_distance(x, y, par, sparse = TRUE)

st_buffer(x, dist, nQuadSegs = 30)

st_boundary(x)

st_convex_hull(x)

st_union_cascaded(x)

st_simplify(x, preserveTopology = FALSE, dTolerance = 0)

st_triangulate(x, dTolerance = 0, bOnlyEdges = FALSE)

st_polygonize(mlst)

st_centroid(x)

st_segmentize(x, dfMaxLength)

st_merge(x, union = FALSE)

st_intersection(x, y0)

st_union(x, y0)

st_difference(x, y0)

st_sym_difference(x, y0)
}
\arguments{
\item{x}{first simple feature (sf) or simple feature geometry (sfc) collection}

\item{y}{second simple feature (sf) or simple feature geometry (sfc) collection}

\item{sparse}{logical; should a sparse matrix be returned (TRUE) or a dense matrix?}

\item{par}{numeric; parameter used for "equals_exact" (margin) and "is_within_distance"}

\item{dist}{buffer distance}

\item{nQuadSegs}{integer; number of segments per quadrant (fourth of a circle)}

\item{preserveTopology}{logical; carry out topology preserving simplification?}

\item{dTolerance}{numeric; tolerance parameter}

\item{bOnlyEdges}{logical; if TRUE, return lines, else return polygons}

\item{mlst}{object of class \code{MULTILINESTRING} or geometry list-column containing these}

\item{dfMaxLength}{numeric; max length of a line segment}

\item{union}{logical; apply \code{st_union_cascaded} to the merged geometry set?}

\item{y0}{object of class \code{sfc} which is merged, using \code{c.sfg} (\link{st}), before intersection etc. with it is computed}
}
\value{
matrix (sparse or dense); if dense: of type \code{character} for \code{relate}, \code{numeric} for \code{distance}, and \code{logical} for all others; matrix has dimension \code{x} by \code{y}; if sparse (only possible for those who return logical in case of dense): return list of length length(x) with indices of the TRUE values for matching \code{y}.

st_is_simple and st_is_valid return a logical vector

st_distance returns a dense numeric matrix of dimension length(x) by length(y)

st_relate returns a dense \code{character} matrix

st_intersects ...  st_is_within_distance return a sparse or dense logical matrix with rows and columns corresponding to the number of geometries (or rows) in x and y, respectively

st_buffer ... st_segmentize return an \link{sfc} object with the same number of geometries as in \code{x}
}
\description{
Geometric operations on (pairs of) simple feature geometries
}
\details{
requires GEOS version 3.4 or above
}
\examples{
# nc = st_read(system.file("gpkg/nc.gpkg", package="sf"), "nc.gpkg", crs = 4267)
nc = st_read(system.file("shape/nc.shp", package="sf"), "nc", crs = 4267)
plot(st_union_cascaded(st_sfc(do.call(c, st_geometry(nc)))),col=0)
mls = st_multilinestring(list(matrix(c(0,0,0,1,1,1,0,0),,2,byrow=TRUE)))
x = st_polygonize(mls)
plot(nc, axes = TRUE)
plot(st_centroid(nc), add = TRUE, pch = 3)
m = st_merge(nc)
plot(st_convex_hull(nc))
plot(nc, border = grey(.5))
}

