% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{crs}
\alias{crs}
\alias{st_crs}
\alias{st_crs.sf}
\alias{st_crs.sfc}
\alias{st_crs<-}
\alias{st_crs<-.sf}
\alias{st_crs<-.sfc}
\title{retrieve coordinate reference system from object}
\usage{
st_crs(x, ...)

\method{st_crs}{sf}(x, ...)

\method{st_crs}{sfc}(x, ...)

st_crs(x) <- value

\method{st_crs}{sf}(x) <- value

\method{st_crs}{sfc}(x) <- value
}
\arguments{
\item{x}{object of class \link{sf} or \link{sfc}}

\item{...}{ignored}

\item{value}{one of (i) character: a valid proj4string (ii) integer, a valid epsg value (numeric), or (iii) a list containing named elements proj4string (character) and/or epsg (integer) with (i) and (ii).}
}
\description{
retrieve coordinate reference system from sf or sfc object.

set or replace retrieve coordinate reference system from object
}
\details{
in case a coordinate reference system is replaced, no transformation takes
place and a warning is raised to stress this. epsg values are either read from proj4strings
that contain \code{+init=epsg:...} or set to 4326 in case the proj4string contains +proj=longlat
and +datum=WGS84, literally

If both epsg and proj4string are provided, they are assumed to be consistent. In processing them, the epsg code, if not missing valued, is used and the proj4string is derived from it by a call to GDAL (which in turn will call PROJ.4). Warnings are raised when epsg is not consistent with a proj4string that is already present.
}
\examples{
 sfc = st_sfc(st_point(c(0,0)), st_point(c(1,1)))
 sf = st_sf(a = 1:2, geom = sfc)
 st_crs(sf) = 4326
 st_geometry(sf)
 sfc = st_sfc(st_point(c(0,0)), st_point(c(1,1)))
 st_crs(sfc) = 4326
 sfc
}

