% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-resource.R
\name{Resource}
\alias{Resource}
\title{R6 Class Representing a Resource}
\description{
Base class for describing a resource.
}
\details{
This is a base class for describing a resource on the platform:
Projects, Tasks, Volumes, Files, Apps etc.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{auth}}{Seven Bridges Authentication object.}

\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Resource-new}{\code{Resource$new()}}
\item \href{#method-Resource-query}{\code{Resource$query()}}
\item \href{#method-Resource-get}{\code{Resource$get()}}
\item \href{#method-Resource-delete}{\code{Resource$delete()}}
\item \href{#method-Resource-clone}{\code{Resource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resource-new"></a>}}
\if{latex}{\out{\hypertarget{method-Resource-new}{}}}
\subsection{Method \code{new()}}{
Create a new Resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resource$new(auth = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{auth}}{Seven Bridges Authentication object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resource-query"></a>}}
\if{latex}{\out{\hypertarget{method-Resource-query}{}}}
\subsection{Method \code{query()}}{
Generic query implementation that is used by the resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resource$query(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters that will be passed to core \code{api()} function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resource-get"></a>}}
\if{latex}{\out{\hypertarget{method-Resource-get}{}}}
\subsection{Method \code{get()}}{
Generic get implementation that fetches single resource
from the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resource$get(cls, id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cls}}{Resource class object.}

\item{\code{id}}{Object id.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resource-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Resource-delete}{}}}
\subsection{Method \code{delete()}}{
Generic implementation that deletes the resource
from the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resource$delete(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Object id.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function.}

\item{\code{cls}}{Resource class object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Resource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
