% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-auth.R
\name{Auth}
\alias{Auth}
\title{R6 Class Representing Authentication Object}
\description{
Authentication object with methods to access API endpoints.
Every object could be requested from this Auth object and any action
could start from this object using cascading style. Please check
\code{vignette("Authentication_and_Billing", package = "sevenbridges2")}
for more information.
}
\details{
This is the main object for authentication to platforms powered by
Seven Bridges.
}
\examples{

## ------------------------------------------------
## Method `Auth$new`
## ------------------------------------------------

\dontrun{
 # Multiple ways to create Auth object

 # Using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Authenticate using environment variables
 a <- Auth$new(from = "env")

 # Authenticate using file configuration
 a <- Auth$new(from = "file")

}

## ------------------------------------------------
## Method `Auth$get_token`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Get that same token
 a$get_token()
}


## ------------------------------------------------
## Method `Auth$api`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Create API request using request parameters directly
 a$api(params)
}


## ------------------------------------------------
## Method `Auth$user`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Get information about the currently authenticated user
 a$user()
}

## ------------------------------------------------
## Method `Auth$rate_limit`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Get current rate limit
 a$rate_limit()
}


## ------------------------------------------------
## Method `Auth$upload`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Create upload job and set destination project
 upload_job <- a$upload(
   path = "/path/to/your/file.txt",
   project = destination_project,
   overwrite = TRUE,
   init = TRUE
 )
}

## ------------------------------------------------
## Method `Auth$list_ongoing_uploads`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # List ongoing uploads
 a$list_ongoing_uploads()
}

## ------------------------------------------------
## Method `Auth$upload_abort`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Abort upload
 a$abort_upload(upload_id = "<id_of_the_upload_process>")
}

## ------------------------------------------------
## Method `Auth$send_feedback`
## ------------------------------------------------

\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Send feedback
 a$send_feedback(
  "This is a test for sending feedback via API.",
  type = "thought"
 )
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{from}}{Authentication method.}

\item{\code{platform}}{The platform to use.}

\item{\code{url}}{Base URL for API.}

\item{\code{sysenv_url}}{Name of the system environment variable storing
the API base URL.}

\item{\code{sysenv_token}}{Name of the system environment variable storing
the auth token.}

\item{\code{config_file}}{Location of the user configuration file.}

\item{\code{profile_name}}{Profile name in the user configuration file.}

\item{\code{fs}}{FS (FileSystem) object, for mount and unmount file system.}

\item{\code{authorization}}{Is the \code{token} an API
authentication token (\code{FALSE}) or an access token from the
Seven Bridges single sign-on (\code{TRUE})?}

\item{\code{projects}}{Projects object, for accessing projects resources on the
platform.}

\item{\code{files}}{Files object, for accessing files resources on the
platform.}

\item{\code{apps}}{Apps object, for accessing apps resources on the platform.}

\item{\code{volumes}}{Volumes object, for accessing volumes resources on the
platform.}

\item{\code{tasks}}{Tasks object, for accessing volumes resources on the
platform.}

\item{\code{imports}}{Storage imports object, for accessing volume imports
resources on the platform.}

\item{\code{exports}}{Storage exports object, for accessing volume exports
resources on the platform.}

\item{\code{invoices}}{Invoices object, for accessing invoice resources on the
platform.}

\item{\code{billing_groups}}{Billing_groups object, for accessing billing groups
resources on the platform.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Auth-new}{\code{Auth$new()}}
\item \href{#method-Auth-get_token}{\code{Auth$get_token()}}
\item \href{#method-Auth-api}{\code{Auth$api()}}
\item \href{#method-Auth-user}{\code{Auth$user()}}
\item \href{#method-Auth-rate_limit}{\code{Auth$rate_limit()}}
\item \href{#method-Auth-upload}{\code{Auth$upload()}}
\item \href{#method-Auth-list_ongoing_uploads}{\code{Auth$list_ongoing_uploads()}}
\item \href{#method-Auth-upload_abort}{\code{Auth$upload_abort()}}
\item \href{#method-Auth-send_feedback}{\code{Auth$send_feedback()}}
\item \href{#method-Auth-clone}{\code{Auth$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-new"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-new}{}}}
\subsection{Method \code{new()}}{
Create a new Seven Bridges API Authentication object.
All methods can be accessed through this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$new(
  from = c("direct", "env", "file"),
  platform = NA,
  url = NA,
  token = NA,
  sysenv_url = NA,
  sysenv_token = NA,
  config_file = NA,
  profile_name = NA,
  fs = NA,
  authorization = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{Authentication method. Could be:
\itemize{
\item \code{"direct"} - pass the credential information to the arguments
directly,
\item \code{"env"} - read from pre-set system environment variables, or
\item \code{"file"} - read configurations from a credentials file.
}
Default is \code{"direct"}.}

\item{\code{platform}}{The platform to use.
If \code{platform} and \code{url} are both not specified,
the default is \code{"aws-us"} (Seven Bridges Platform - US).
Other possible values include:
\itemize{
\item \code{"aws-eu"} - Seven Bridges Platform - EU,
\item\code{"cgc"} - Cancer Genomics Cloud,
\item\code{"ali-cn"} - Seven Bridges Platform - China,
\item\code{"cavatica"} - Cavatica, and
\item\code{"f4c"} - BioData Catalyst Powered by Seven Bridges.
}}

\item{\code{url}}{Base URL for API. Please only use this when you
want to specify a platform that is not in the \code{platform} list
above, and also leaving \code{platform} unspecified.}

\item{\code{token}}{API authentication token or \code{access_token} for
Seven Bridges single sign-on. Authentication token uniquely identifies
you on the Seven Bridges Platform and has all your data access,
app management and task execution permissions.
Read more about its usage
\href{https://docs.sevenbridges.com/docs/get-your-authentication-token}{here}.}

\item{\code{sysenv_url}}{Name of the system environment variable storing
the API base URL. By default: \code{"SB_API_ENDPOINT"}.}

\item{\code{sysenv_token}}{Name of the system environment variable storing
the auth token. By default: \code{"SB_AUTH_TOKEN"}.}

\item{\code{config_file}}{Location of the user configuration file. \cr
By default: \code{"~/.sevenbridges/credentials"}.}

\item{\code{profile_name}}{Profile name in the user configuration file.
The default value is \code{"default"}.}

\item{\code{fs}}{FS (FileSystem) object, for mount and unmount file system.}

\item{\code{authorization}}{Is the \code{token} an API
authentication token (\code{FALSE}) or an access token from the
Seven Bridges single sign-on (\code{TRUE})?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{Auth} class object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Multiple ways to create Auth object

 # Using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Authenticate using environment variables
 a <- Auth$new(from = "env")

 # Authenticate using file configuration
 a <- Auth$new(from = "file")

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-get_token}{}}}
\subsection{Method \code{get_token()}}{
Returns the authentication token read from
system environment variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$get_token()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An API authentication token in form of a string.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Get that same token
 a$get_token()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-api"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-api}{}}}
\subsection{Method \code{api()}}{
This method returns all API paths and
pass arguments to core \code{api()} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$api(
  ...,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  fields = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments passed to core \code{api()} function, like \code{path},
\code{query} parameters or full \code{url} to some resource.}

\item{\code{limit}}{The maximum number of collection items to return for a
single request. Minimum value is \code{1}. The maximum value is \code{100} and the
default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection of
the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{fields}}{Selector specifying a subset of fields to include in the
response. This parameter enables you to specify the fields you want to
be returned when listing resources (e.g. all your projects) or
getting details of a specific resource (e.g. a given project). \cr \cr
For example, \code{fields="id,name,size"} to return the fields
id, name and size for files. Default value is set to
\verb{_all}, so all fields are always returned for each resource.
More details please check
\href{https://docs.sevenbridges.com/docs/the-api#section-general-api-information}{general API documentation}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Create API request using request parameters directly
 a$api(params)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-user"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-user}{}}}
\subsection{Method \code{user()}}{
Get details about the authenticated user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$user(username = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{username}}{The username of a user for whom you want to get basic
account information. If not provided, information about the currently
authenticated user will be returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{User} class object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Get information about the currently authenticated user
 a$user()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-rate_limit"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-rate_limit}{}}}
\subsection{Method \code{rate_limit()}}{
Get information about current rate limit. \cr \cr
This call returns information about your current rate limit. This is the
number of API calls you can make in one hour. This call also returns
information about your current instance limit.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$rate_limit()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Get current rate limit
 a$rate_limit()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-upload"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-upload}{}}}
\subsection{Method \code{upload()}}{
This method allows you to upload a single file from your
local computer to the Platform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$upload(
  path,
  project = NULL,
  parent = NULL,
  filename = NULL,
  overwrite = FALSE,
  part_size = getOption("sevenbridges2")$RECOMMENDED_PART_SIZE,
  init = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{File path on local disk.}

\item{\code{project}}{\code{Project} object or its ID. Project should not be used
together with parent. If parent is used, the call will upload the file
to the specified Platform folder, within the project to which the
folder belongs. If project is used, the call will upload the file to
the root of the project's files.}

\item{\code{parent}}{Parent folder object (of \code{File} class) or its ID.
Should not be used together with project. If parent is used, the call
will upload the file to the
specified Platform folder, within the project to which the folder
belongs. If project is used, the call will upload the file to the root
of the project's files.}

\item{\code{filename}}{Optional new file name. By default the uploaded file will
have the same name as the original file provided with the \code{path}
parameter. If its name will not change, omit this key.}

\item{\code{overwrite}}{In case there is already a file with the same name in
the selected platform project or folder, this option allows you to
control whether that file will be overwritten or not.
If overwrite is set to \code{TRUE} and a file already exists under the name
specified in the request, the existing file will be deleted and a new
one created in its place.}

\item{\code{part_size}}{The preferred size for upload parts in bytes. If omitted
or set to a value that is incompatible with the cloud storage provider,
a default value will be used.}

\item{\code{init}}{If \code{TRUE}, the method will initialize and return the Upload
object and stop. If \code{FALSE}, the method will return the Upload object
and start the upload process immediately.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Create upload job and set destination project
 upload_job <- a$upload(
   path = "/path/to/your/file.txt",
   project = destination_project,
   overwrite = TRUE,
   init = TRUE
 )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-list_ongoing_uploads"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-list_ongoing_uploads}{}}}
\subsection{Method \code{list_ongoing_uploads()}}{
This method returns the list of all ongoing uploads.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$list_ongoing_uploads()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # List ongoing uploads
 a$list_ongoing_uploads()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-upload_abort"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-upload_abort}{}}}
\subsection{Method \code{upload_abort()}}{
This call aborts an ongoing multipart upload.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$upload_abort(upload_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{upload_id}}{Upload object or ID of the upload process that you want
to abort.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Abort upload
 a$abort_upload(upload_id = "<id_of_the_upload_process>")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-send_feedback"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-send_feedback}{}}}
\subsection{Method \code{send_feedback()}}{
Send feedback to Seven Bridges. \cr \cr
Send feedback on ideas, thoughts, and problems via the sevenbridges2 API
package with three available types: \code{idea}, \code{thought}, and \code{problem}.
You can send one feedback item per minute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$send_feedback(
  text,
  type = c("idea", "thought", "problem"),
  referrer = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{Specifies the content for the feedback i.e. feedback text.}

\item{\code{type}}{Specifies the type of feedback. The following are available:
\code{idea}, \code{thought} and \code{problem}.}

\item{\code{referrer}}{The name of the person submitting the feedback.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # Authenticate using authentication token
 a <- Auth$new(
  token = "<your_token>",
  platform = "aws-us"
 )

 # Send feedback
 a$send_feedback(
  "This is a test for sending feedback via API.",
  type = "thought"
 )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Auth-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Auth-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Auth$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
