\name{restoreSession}
\alias{restoreSession}
\title{
Restore an R Session
}
\description{
A wrapper function for restoring a session from a binary file.
}
\usage{
restoreSession(file = "session.RData", envir = .GlobalEnv, clean = TRUE)
}
\arguments{
  \item{file}{
path to an R binary file
}
  \item{envir}{
the environment into which the objects should be restored.
}
  \item{clean}{
boolean indicating whether the environment should be purged prior to restoring objects
}
  
}
\details{
This function restores an entire workspace by calling \code{\link{restoreObjects}}, followed
by calls to \code{\link{restorePackages}}, \code{\link{restoreSearchPath}} and \code{\link{restoreOptions}}
if the file contains an object named .sessionInfo, that must be generated by a call to \code{\link{sessionSummary}}
}
\value{
This function is called for it's side-effects
}
\author{
Matthew D. Furia \email{matt.furia@sagebase.org}

\url{https://github.com/MattNapsAlot}
}

\seealso{
\code{\link{restoreObjects}},
\code{\link{restoreSearchPath}},
\code{\link{restorePackages}},
\code{\link{restoreOptions}},
\code{\link{sessionSummary}},
\code{\link{saveSession}}
}
\examples{
\dontrun{
## save the session
saveSession(file="sessionInfo.rbin")

## restore a saved session
restoreSession(file="sessionInfo.rbin")
}
}
