% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_management.R
\name{sst_pm_delete_project}
\alias{sst_pm_delete_project}
\title{Delete the existing project}
\usage{
sst_pm_delete_project(api_token, project_id = NULL)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{project_id}{(required) ID of the project in Serpstat.}
}
\value{
Returns the state of the deletion operation.
}
\description{
Deletes the existing project in Serpstat by project ID.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/project-deletion/}{here}.
}

\section{API credits consumption}{
 returns 1 project credit.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_pm_delete_project(
  api_token  = api_token,
  project_id = 12345
  )
}
}
