% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drill-docker.R
\name{drill_up}
\alias{drill_up}
\alias{drill_down}
\title{Start a Dockerized Drill Instance}
\usage{
drill_up(
  image = "drill/apache-drill:1.16.0",
  container_name = "drill",
  data_dir = getwd(),
  remove = TRUE
)

drill_down(id)
}
\arguments{
\item{image}{Drill image to use. Must be a valid image from
\href{https://hub.docker.com/u/drill}{Drill's Docker Hub}. Defaults
to most recent Drill docker image.}

\item{container_name}{naem for the container. Defaults to "\code{drill}".}

\item{data_dir}{valid path to a place where your data is stored; defaults to the
value of \code{\link[=getwd]{getwd()}}. This will be \code{\link[=path.expand]{path.expand()}}ed and mapped to \verb{/data}
in the container. This will be mapped to the \code{dfs} storage plugin as the
\code{dfs.d} workspace.}

\item{remove}{remove the Drill container instance after it's stopped?
Defaults to \code{TRUE} since you shouldn't be relying on this in production.}

\item{id}{the id of the Drill container}
}
\value{
a \code{stevedore} docker object (invisibly) which \emph{you} are responsible
for killing with the \verb{$stop()}  function or from the Docker command
line (in interactive mode the docker container ID is printed as well).
}
\description{
This is a "get you up and running quickly" helper function as it only
runs a standalone mode Drill instance and is optionally removed after the container
is stopped. You should customize your own Drill containers based on the
one at \href{https://hub.docker.com/u/drill}{Drill's Docker Hub}.
}
\details{
The path specified in \code{data_dir} will be mapped inside the container as
\verb{/data} and a new \code{dfs} storage workspace will created (\code{dfs.d}) that
maps to \verb{/data} and is writable.

Use \code{\link[=drill_down]{drill_down()}} to stop a running Drill container by container id
(full or partial).
}
\note{
this requires a working Docker setup on your system and it is \emph{highly suggested}
you \verb{docker pull} it yourself before running this function.
}
\examples{
\dontrun{
drill_up(data_dir = "~/Data")
}
}
\seealso{
Other Drill Docker functions: 
\code{\link{killall_drill}()},
\code{\link{showall_drill}()}
}
\concept{Drill Docker functions}
