% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{package}
\name{sentometrics-package}
\alias{sentometrics}
\alias{sentometrics-package}
\title{sentometrics: An Integrated Framework for Textual Sentiment Time Series Aggregation and Prediction}
\description{
The \pkg{sentometrics} package is an integrated framework for textual sentiment time series
aggregation and prediction. It accounts for the intrinsic challenge that, for a given text, sentiment can
be computed in many different ways, as well as the large number of possibilities to pool sentiment across
texts and time. This additional layer of manipulation does not exist in standard text mining and time series
analysis packages. The package therefore integrates the fast \emph{quantification} of sentiment from texts,
the \emph{aggregation} into different sentiment time series and the optimized \emph{prediction} based on
these measures.
}
\note{
Please cite the package in publications. Use \code{citation("sentometrics")}.
}
\section{Main functions}{

\itemize{
\item Corpus (features) generation: \code{\link{sento_corpus}}, \code{\link{add_features}},
\code{\link{as.sento_corpus}}
\item Sentiment computation and aggregation into sentiment measures: \code{\link{ctr_agg}},
\code{\link{sento_lexicons}}, \code{\link{compute_sentiment}}, \code{\link{aggregate.sentiment}},
\code{\link{as.sentiment}}, \code{\link{sento_measures}}, \code{\link{aggregate.sento_measures}},
\code{\link{peakdocs}}, \code{\link{peakdates}}
\item Sparse modelling: \code{\link{ctr_model}}, \code{\link{sento_model}}
\item Prediction and post-modelling analysis: \code{\link{predict.sento_model}},
\code{\link{attributions}}
}
}

\references{
Ardia, Bluteau and Boudt (2019). ``Questioning the news about economic growth: Sparse forecasting using
thousands of news-based sentiment values''. \emph{International Journal of Forecasting 35, 1370-1386},
\url{https://doi.org/10.1016/j.ijforecast.2018.10.010}.

Ardia, Bluteau, Borms and Boudt (2019). ``The R package sentometrics to compute, aggregate and
predict with textual sentiment''. \emph{Working paper}, \url{https://doi.org/10.2139/ssrn.3067734}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/sborms/sentometrics}
  \item Report bugs at \url{https://github.com/sborms/sentometrics/issues}
}

}
\author{
\strong{Maintainer}: Samuel Borms \email{samuel.borms@unine.ch} (0000-0001-9533-1870)

Authors:
\itemize{
  \item David Ardia \email{david.ardia@hec.ca} (0000-0003-2823-782X)
  \item Keven Bluteau \email{keven.bluteau@unine.ch} (0000-0003-2990-4807)
  \item Kris Boudt \email{kris.boudt@vub.be} (0000-0002-1000-5142)
}

Other contributors:
\itemize{
  \item Jeroen Van Pelt \email{jeroenvanpelt@hotmail.com} [contributor]
  \item Andres Algaba \email{andres.algaba@vub.be} [contributor]
}

}
