% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_main.R
\name{peakdates}
\alias{peakdates}
\title{Extract dates related to sentiment time series peaks}
\usage{
peakdates(sentomeasures, n = 10, type = "both", do.average = FALSE)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{n}{a positive \code{numeric} value to indicate the number of dates associated to sentiment peaks to extract.
If \code{n < 1}, it is interpreted as a quantile (for example, 0.07 would mean the 7\% most extreme dates).}

\item{type}{a \code{character} value, either \code{"pos"}, \code{"neg"} or \code{"both"}, respectively to look
for the \code{n} dates related to the most positive, most negative or most extreme (in absolute terms) sentiment
occurrences.}

\item{do.average}{a \code{logical} to indicate whether peaks should be selected based on the average sentiment
value per date.}
}
\value{
A vector of type \code{"Date"} corresponding to the \code{n} extracted sentiment peak dates.
}
\description{
This function extracts the dates for which aggregated sentiment is most
extreme (lowest, highest or both in absolute terms). The extracted dates are unique, even when,
for example, all most extreme sentiment values (for different sentiment measures) occur on only
one date.
}
\examples{
set.seed(505)

data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "month", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# extract the peaks
peaksAbs <- peakdates(sentomeasures, n = 5)
peaksAbsQuantile <- peakdates(sentomeasures, n = 0.50)
peaksPos <- peakdates(sentomeasures, n = 5, type = "pos")
peaksNeg <- peakdates(sentomeasures, n = 5, type = "neg")

}
\author{
Samuel Borms
}
