% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentocorpus.R
\name{add_features}
\alias{add_features}
\title{Add feature columns to a sentocorpus}
\usage{
add_features(sentocorpus, featuresdf = NULL, keywords = NULL)
}
\arguments{
\item{sentocorpus}{a \code{sentocorpus} object created with \code{\link{sento_corpus}}.}

\item{featuresdf}{a named \code{data.frame} of type \code{numeric} where each columns is a new feature to be added to the
inputted \code{sentocorpus} object. If the number of rows in \code{featuresdf} is not equal to the number of documents
in \code{sentocorpus}, recycling will occur.}

\item{keywords}{a named \code{list}. For every element, a new feature column is added with a value of 1 for the texts
in which the keyword(s) appear(s), and 0 if not. If no texts match a keyword, no column is added. The \code{list} named
elements are used as the names of the new features.}
}
\value{
An updated \code{sentocorpus} object.
}
\description{
Adds new feature columns, either user-supplied or based on a simple keyword(s) search, to a provided
\code{sentocorpus} object.
}
\details{
If a provided feature name is already part of the corpus, it will be replaced. The \code{featuresdf} and
\code{keywords} arguments can be provided at the same time, or only one of them, leaving the other at \code{NULL}.
}
\examples{
data("usnews")

# construct a corpus and add random features to it
corpus <- sento_corpus(corpusdf = usnews)
corpus1 <- add_features(corpus,
                        featuresdf = data.frame(random = runif(quanteda::ndoc(corpus))))
corpus2 <- add_features(corpus,
                        keywords = list(pres = "president", war = "war"))

}
\author{
Samuel Borms
}
