% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediationmethods.R
\name{summary.effectsMed}
\alias{summary.effectsMed}
\title{Summary function for objects of class \code{"effectsMed"}}
\usage{
\method{summary}{effectsMed}(object, non.sign = FALSE, ...)
}
\arguments{
\item{object}{object of class \code{"effectsMed"}}

\item{non.sign}{logical indicating whether sensitivity analysis results should be printed for non-significant effects.}

\item{...}{additional arguments}
}
\value{
A list with values:
\item{call}{The matched call}
\item{Rho}{The sensitivity parameter vector.}
\item{type}{character, the type of confounding the sensitivity analysis is performed for.}
\item{conf.level}{numeric, the confidence level used for confidence intervals and uncertainty intervals.}
\item{UI}{matrix with the uncertainty intervals for the NIE (NIE*) and NDE (NDE*) over the range of the sensitivity parameter \code{Rho}.}
\item{covariates}{list of the covariate values that the effects are conditioned on.}
\item{exp.name}{character vector containing the name of the exposure.}
\item{med.name}{character vector containing the name of the mediator.}
\item{alt.decomposition}{logical, indicating whether the alternative definitions of the direct and indirect effects have been used}
\item{non.sign}{logical indicating whether sensitivity analysis results are printed for non-significant effects.}
\item{effects}{Results of the mediation analysis. Estimated NIE and NDE with confidence intervals and p-values for \code{Rho = 0}}
\item{ns.nie}{values of \code{Rho} with estimated NIEs and confidence intervals where the NIE is not significant.}
\item{ns.nde}{values of \code{Rho} with estimated NDEs and confidence intervals where the NDE is not significant.}
\item{rev.nie}{values of \code{Rho} with estimated NIEs and confidence intervals where the NIE is reversed.}
\item{rev.nde}{values of \code{Rho} with estimated NDEs and confidence intervals where the NDE is reversed.}
}
\description{
Summary function for objects of class \code{"effectsMed"}
}
