% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_binpaths.R
\name{load_binpaths}
\alias{load_binpaths}
\title{Load the paths of external executables}
\usage{
load_binpaths(bins = NULL)
}
\arguments{
\item{bins}{Character vector with one of more of the following values:
"gdal", sen2cor", "aria2", "python".
If an executable corresponding to the passed \code{bins} value is not found
in the JSON, it is checked (when possible).}
}
\value{
The list of the paths
}
\description{
Internal function to load the paths of executables
from the JSON where they are saved when installed.
}
\note{
License: GPL 3.0
}
\examples{
\donttest{
# Load only existing paths
binpaths <- load_binpaths()
binpaths
}

\dontrun{
# Load paths, forcing to check GDAL and sen2cor
binpaths <- load_binpaths(c("gdal", "sen2cor"))
binpaths
}
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
