% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePval_maxLR.R
\name{computePval_maxLR}
\alias{computePval_maxLR}
\title{Wrapper function for computing the maxLR corrected p value
from strucchange}
\usage{
computePval_maxLR(maxLR, q, covariate, from, to, nrep)
}
\arguments{
\item{maxLR}{maximum of the LR test statistics}

\item{q}{number of free SEM parameters / degrees of freedom}

\item{covariate}{covariate under evaluation. This is important to get the level of
measurement from the covariate and the bin size for ordinal and
categorical covariates.}

\item{from}{numeric from interval (0, 1) specifying start of trimmed
sample period.  With the default 
from = 0.15 the first and last 15 percent of observations are
trimmed. This is only needed for continuous covariates.}

\item{to}{numeric from interval (0, 1) specifying end of trimmed
sample period. By default, to is 1.}

\item{nrep}{numeric. Number of replications used for simulating from the asymptotic 
distribution (passed to efpFunctional). Only needed for ordinal
covariates.}
}
\value{
Numeric. p value for maximally selected LR statistic
}
\description{
Wrapper function for computing the maxLR corrected p value
from strucchange
}
\author{
Manuel Arnold
}
