% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgc.R
\name{lgc}
\alias{lgc}
\title{General function to specify a general latent growth components model.}
\usage{
lgc(
  data,
  mmodel,
  C_matrix,
  hypotheses = NULL,
  covariates = NULL,
  groups = NULL,
  append = NULL,
  verbose = FALSE,
  compound_symmetry = FALSE,
  sphericity = FALSE,
  multiv_tests = c("wilks", "wald"),
  univ_tests = NULL,
  randomization = list(ncores = 1, nsamples = 1000),
  ...
)
}
\arguments{
\item{data}{Dataframe. Data object to be passed to lavaan.}

\item{mmodel}{Object of class \code{mmodel}. If not provided, manifest variables from the formula object will be used.
Otherwise, use \code{create_mmodel()} to specify measurement model.}

\item{C_matrix}{Contrast matrix. Must be invertible.}

\item{hypotheses}{List of numeric vectors. Each list element represents a hypothesis.
For each hypothesis, the contrasts indicated by the elements of the vectors are tested against zero.}

\item{covariates}{Not implemented yet.}

\item{groups}{Not implemented yet.}

\item{append}{Character. Syntax that is to be appended to lavaan syntax.}

\item{verbose}{Boolean. Print details during procedure.}

\item{compound_symmetry}{Boolean. When set to TRUE, compound symmetry is assumed.}

\item{sphericity}{Boolean or formula. When set to TRUE, sphericity is assumed for all effects.}

\item{multiv_tests}{Character vector. Multivariate test statistics that are to be computed.
Possible statistics are: \code{c("wilks", "wald")}. Default is \code{multiv_tests = c("wilks", "wald")}.}

\item{univ_tests}{Character vector. Univariate test statistics that are to be computed.
Possible statistics are: \code{c("F")}. Default is \code{univ_tests = NULL}.}

\item{randomization}{Not yet supported.}

\item{...}{Additional arguments to be passed to lavaan.}
}
\value{
Function returns an lgc object. Use \code{summary(object)} to print
hypotheses. Otherwise use \code{object@sem_obj} to get access to the underlying
lavaan object.
}
\description{
General function to specify a general latent growth components model.
}
\examples{

set.seed(323412431)

data <- get_test_data()

mmodel <- create_mmodel(
    A1B1 = "var1",
    A2B1 = "var2",
    A3B1 = "var3",
    A1B2 = "var4",
    A2B2 = "var5",
    A3B2 = "var6",
    lv_scaling = "referent"
)

hypotheses <- list(
    Intercept = c(1),
    A        = c(2, 3),
    B        = c(4),
    AB       = c(5, 6)
)

C_matrix <- matrix(
    c(1, 1, 0, 1, 1, 0,
      1, 0, 1, 1, 0, 1,
      1,-1,-1, 1,-1,-1,
      1, 1, 0,-1,-1, 0,
      1, 0, 1,-1, 0,-1,
      1,-1,-1,-1, 1, 1),
    nrow=6
)

fit_lgc <- lgc(data, mmodel, C_matrix, hypotheses)
summary(fit_lgc)

}
