% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cibound.R
\name{get_cibound}
\alias{get_cibound}
\title{A 'cibound' Output From a 'semlbci' Object}
\usage{
get_cibound(x, row_id, which = c("lbound", "ubound"))
}
\arguments{
\item{x}{The output of \code{\link[=semlbci]{semlbci()}}.}

\item{row_id}{The row number in \code{x}. Should be the number
on the left, not the actual row number, because some rows
may be omitted in the printout of \code{x}.}

\item{which}{The bound for which the \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}} is
to be extracted. Either \verb{"lbound"`` or }"ubound"``.}
}
\value{
A \code{cibound}-class object. See \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}
for details.
}
\description{
Get the \code{cibound} output of a bound from
a \code{semlbci} object, the output of \code{\link[=semlbci]{semlbci()}}.
}
\details{
It returns the original output of \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}
for a bound. Usually for diagnosis.
}
\examples{

library(lavaan)
mod <-
"
m ~ a*x
y ~ b*m
ab := a * b
"
fit_med <- sem(mod, simple_med, fixed.x = FALSE)
p_table <- parameterTable(fit_med)
p_table
lbci_med <- semlbci(fit_med,
                    pars = c("ab :="))
lbci_med

# Get the output of ci_bound_wn_i() of the lower
# bound of the LBCI for the indirect effect:
get_cibound(lbci_med, row_id = 6, which = "lbound")

# Get the output of ci_bound_wn_i() of the upper
# bound of the LBCI for the indirect effect:
get_cibound(lbci_med, row_id = 6, which = "ubound")

}
\seealso{
\code{\link[=semlbci]{semlbci()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
