% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLB.R
\name{FLB}
\alias{FLB}
\title{Full-likelihood Bayes factor}
\usage{
FLB(
  x,
  carriers,
  noncarriers = NULL,
  freq,
  affected,
  unknown = NULL,
  proband,
  penetrances,
  liability = NULL,
  details = FALSE,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{\link[pedtools:ped]{pedtools::ped()}} object.}

\item{carriers}{A character vector (or coercible to such), containing the ID
labels of pedigree members known to carry the variant in question.}

\item{noncarriers}{A character vector (or coercible to such), containing the
ID labels of pedigree members known \emph{not} to carry the variant in question.}

\item{freq}{A single number strictly between 0 and 1: the population
frequency of the observed allele.}

\item{affected}{The affected pedigree members.}

\item{unknown}{Pedigree members with unknown affection status.}

\item{proband}{The ID label of the proband. This person must also be in both
\code{carriers} and \code{affected}.}

\item{penetrances}{Either a numeric vector of length 3, corresponding to
\verb{(f0, f1, f2)} or a matrix or data frame with 3 columns. Each row contains
the penetrance values of a liability class.}

\item{liability}{A vector of length \code{pedsize(x)}, containing for each
pedigree member the row number of \code{penetrances} which should be used for
that individual. (If \code{penetrances} is just a vector, it will be used for
all classes.) If \code{liability} is NULL (the default), it is set to \code{1} for
all individuals.}

\item{details}{A logical, indicating if detailed output should be returned
(for debugging purposes).}

\item{plot}{A logical.}

\item{...}{Optional plot parameters passed on to \code{\link[pedtools:plot.ped]{pedtools::plot.ped()}}.}
}
\value{
A positive number. If \code{details = TRUE}, a list of intermediate
results is returned.
}
\description{
Computes the Bayes factor for co-segregation, as described by Thompson et al.
(2003).
}
\examples{

x = nuclearPed(2)

FLB(x, carriers = 3:4, aff = 3:4, unknown = 1:2,
    freq = 0.0001, penetrances = c(0, 1, 1), proband = 3)

}
\references{
Thompson D, Easton DF, Goldgar DE. \emph{A full-likelihood method for
the evaluation of causality of sequence variants from family data.} Am J
Hum Genet, 2003. \doi{10.1086/378100}.
}
