% Generated by roxygen2 (4.0.2): do not edit by hand
\name{segmag}
\alias{segmag}
\title{Create Segmentation Object}
\usage{
segmag(ids, time_keypresses, data = NULL,
  time_min = (min(min(time_keypresses), (min(time_keypresses) + gauss_offset))
  - gauss_cutoff), time_max = (max(max(time_keypresses), (max(time_keypresses)
  + gauss_offset)) + gauss_cutoff), time_steps = 0.01, gauss_offset = 0,
  gauss_sd = 1, gauss_cutoff = 6 * gauss_sd)
}
\arguments{
\item{ids}{factor assigning a participant id to each key press (same length as
time_keypresses)}

\item{time_keypresses}{numeric vector with the times when the segmentation key
was pressed on the keyboard}

\item{data}{optional data.frame where ids and time_keypresses are stored in}

\item{time_min}{time window of key press times used in calculations}

\item{time_max}{time window of key press times used in calculations}

\item{time_steps}{interval length of time steps within time window}

\item{gauss_offset}{offset the overlaid Gaussian relative to the key press times
in order to account for manual reaction times (0: centered,
negative values: assume that event boundary occurred before key press)}

\item{gauss_sd}{sd of overlaid Gaussian}

\item{gauss_cutoff}{speed up calculations by not considering values of the overlaid Gaussian
that are more than gauss_cutoff units from the center of the Gaussian away
(because they are very close to 0)}
}
\value{
segmag object (also contains a data.frame with segmentation magnitude across time as $data)
}
\description{
This function creates a segmag object from a vector of participant ids and
a vector of times when the participants pressed the segmentation key on the keyboard.
All functions in the segmag package work on this object (e.g., plotting results,
determining event boundaries). The additional parameters define the size and
offset of the Gaussian that is centered around each key press and the time window
in the data set to consider (time_min, time_max, time_steps).
}
\details{
First, segmentation magnitude for each participant across time is calculated
by centering a Gaussian around each key press. If multiple Gaussians overlap
across time then only the maximum values is used (not sum) to ensure an equal
weight of each participant on the overall segmentation magnitude. Thereafter,
the segmentation magnitudes of the participants are summed up to define the
overall segmentation magnitude across time. The higher the segmentation magnitude
at one point in time the more participants pressed a key around this time
point. To account for the fact that participants have a certain temporal error
in their key presses, Gaussians are used to expand the influence of a single key press
into time. Furthermore, an offset to these Gaussians can be defined in order to
account for manual reaction times and to get a better estimate of the "real"
time point of an event boundary.

In order to achieve a decent calculation speed, a fixed time scale with interval length
time_steps and starting from time_min is used. All key-press times are rounded to their closest
interval. A warning is issued if this changes the raw key-press times.
}
\examples{
# segmentation responses (key presses) of 6 participants watching a movie (30 seconds long)
participant_ids <- factor(c(1,1,1,1,2,2,3,3,3,3,4,4,4,5,5,6,6,6))
time_keypresses <- c(7,12,18,25,12.1,24.9,6.9,10,25.2,29,7.2,12.05,17.5,7.05,25,6.9,16.1,25)

# create segmag object
segmag1 <- segmag(participant_ids, time_keypresses, time_min=0, time_max=30)

\dontrun{
# estimate the critical cutoff against an alpha level of 0.05
# Note: This is an estimate an will vary slightly against multiple calls of this function
#       (variation is the lower the higher n_bootstrap is set)
critical_cutoff <- bootstrap_critical_cutoffs(segmag1, 5000, .95)
}
\dontshow{
critical_cutoff <- 1.623081
}

# timestamps of significant event boundaries within the movie
eb_times <- get_eb_times(segmag1, critical_cutoff)

plot(segmag1, critical_cutoff, eb_times)
}
\seealso{
\code{\link{bootstrap_critical_cutoffs}}, \code{\link{get_eb_times}}, \code{\link{plot.segmag}}
}

