% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segclust.R
\name{segclust_internal}
\alias{segclust_internal}
\title{Internal segmentation/clustering function}
\usage{
segclust_internal(x, seg.var = NULL, diag.var = NULL,
  order.var = NULL, scale.variable = NULL, Kmax, ncluster = NULL,
  lmin = NULL, dat = NULL, type = NULL, sameSigma = F,
  subsample_over = 1000, subsample_by = NA, subsample = TRUE, ...)
}
\arguments{
\item{x}{data used for segmentation. Supported: data.frame, Move object,
ltraj object}

\item{seg.var}{for behavioral segmentation: names of the variables used for
segmentation (either one or two names).}

\item{diag.var}{for behavioral segmentation: names of the variables on which
statistics are calculated.}

\item{order.var}{for behavioral segmentation: names of the variable with
which states are ordered.}

\item{scale.variable}{should variables be standardized ? (reduced and centered)}

\item{Kmax}{maximum number of segments.}

\item{ncluster}{number of cluster into which segments should be grouped. Can
be a vector if one want to test several number of clusters.}

\item{lmin}{minimum length of segments.}

\item{dat}{bivariate data (one signal per row)}

\item{type}{type of segmentation. Either "home-range" or "behavior". Changes
default values of arguments order, scale.variable in the different
functions used on the output. Default for segmentation: "home-range";
default for segmentation/clustering : "behavior".}

\item{sameSigma}{does segments have same variance ?}

\item{subsample_over}{over which size should subsampling begin (depending on
speed and memory limitations)}

\item{subsample_by}{override subsample_over to adjust manually subsampling}

\item{subsample}{if FALSE disable subsample}

\item{...}{additional arguments given to \code{\link{chooseseg_lavielle}}}
}
\description{
Internal segmentation/clustering function
}
