% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_covariates.R
\name{add_covariates}
\alias{add_covariates}
\alias{add_covariates.Move}
\alias{add_covariates.ltraj}
\alias{add_covariates.data.frame}
\title{Covariate Calculations}
\usage{
add_covariates(x, ...)

\method{add_covariates}{Move}(x, coord.names = c("x", "y"), ...)

\method{add_covariates}{ltraj}(x, coord.names = c("x", "y"), ...)

\method{add_covariates}{data.frame}(x, coord.names = c("x", "y"),
  smoothed = F, timecol = "dateTime", units = "hour", radius = NULL,
  ...)
}
\arguments{
\item{x}{movement data}

\item{...}{additional arguments}

\item{coord.names}{names of coordinates column in \code{x}}

\item{smoothed}{whether speed are smoothed or not}

\item{timecol}{names of POSIXct time column}

\item{units}{units for time calculation. Default "hour"}

\item{radius}{for spatial angle calculations}
}
\value{
data.frame with additional covariates
}
\description{
Add several covariates to movement observations
\code{add_covariates} add several covariates to a data frame with movement
information. It adds : distance between location, spatial angle, speed,
smoothed speed, persistence and rotation velocity (calculated with spatial
angle).

add_covariates method for Move object

add_covariates method for ltraj object

add_covariates method for data.frame
}
\examples{
\dontrun{add_covariates(move_object, coord.names = c("x","y"), smoothed = T)}
\dontrun{
data(simulmode)
simple_data <- simulmode[,c("dateTime","x","y")]
full_data   <- add_covariates(simple_data, coord.names = c("x","y"),
 timecol = "dateTime",smoothed = TRUE, units ="min")
}
}
