% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Class-searchable.R
\docType{class}
\name{searchable-class}
\alias{is.searchable}
\alias{searchable}
\alias{searchable-class}
\alias{show,searchable-method}
\title{searchable}
\usage{
searchable(object, ...)

\S4method{show}{searchable}(object)

is.searchable(object)
}
\arguments{
\item{object}{searchable object or object to be made searchable}

\item{...}{one or more stringr-style match modifying sunctions, See
  \code{?match.modifiers} for details.}
}
\value{
By default, the extraction from a searchable objects is not a class
  searchable. It is assumed that in most cases, the developer will not want
  another searchable object.
}
\description{
Creates a searchable class that allows for modification for searches.

is.searchable
}
\details{
The searchable class allows for non-standard, stringr-like searches when
extracting (or replacing) objects. The following
modification are (at present) supported: \code{fixed},
\code{ignore.case}, \code{perl} and
\code{reverse.lookup}.

Search modification can be applied either to the object being searched or
the search pattern(s). To apply them to the searched object add the modifiers
to the \code{modifiers} slot of the object. These are applied after any user
supplied modifiers.

\code{searchable} is designed to be minimally invase. No modification to the
object or its names are made when classing an object as searcable and if no
search modifiers are enabled, the object behaves as a regular,
"non-searchable" object.
}
\note{
- Environments cannot be (easily) be made "searchable" due to the way the
  objects are implemented
  - The extraction methods for searchable objects are (at present) limited to
    only one pattern. This
}
\section{reverse.lookup}{


When performing a reverse lookup, values (not names) are searched. The
corresponding names are returned.  NOTE: this is highly experimental and only
works for atomic vectors. It is uncertain how this might be applied to
recursive structures.
}

\section{replacement}{


\code{searchable} can be used to replace objects as well. See \code{?extract}
for additional exemples.
}

\section{multiple dimension objects}{


Multiple dimension ojects such as data.frames, data.tables, matrices and
arrays are not supported at this time.
}

\section{Adding new modifiers}{


It is possible to add additional search modifiers ... (vignette)
}
\examples{
# ATOMIC VECTORS:
    v <- c( a=1, b=2, B=3, c=4, c2=5 )
    sv <- searchable(v)

  # EXTRACT:
    sv$a

    sv[['a']]
    sv[[ ignore.case('A') ]]

    sv[ ignore.case('b') ]
    sv[ perl('c') ]
    sv[ fixed('c') ]


  # REPLACEMENT:
    sv$a               <- "first"
    sv[['a']]          <- "1st"
    sv[[ perl('c.') ]] <- "third"

    sv[ perl('c.?') ]   <- "3rd"


  # MODIFIERS TO SEARCH TARGET/OBJECT
    sv <- searchable(v, ignore.case )
    sv$A
    sv['b']
    sv['B']


  # RECURSIVE LISTS:
    l <- list( a=1, b=2, c=3 )
    sl <- searchable(l)
    sl[["b"]]
    sl[[ ignore.case("B") ]]

  # USE WITH MAGRITTR
   \dontrun{
    sl[[ "B"  \%>\% ignore.case ]]
    "b" \%>\% sl[[.]]
    "B" \%>\% ignore.case \%>\% sl[[ . ]]
   }
}
\seealso{
\code{\link{extract}}              \cr
  \code{\link[stringr]{ignore.case}} \cr
  \code{\link[stringr]{perl}}        \cr
  \code{\link{reverse.lookup}}       \cr
}

