% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{list_crawl_error_samples}
\alias{list_crawl_error_samples}
\title{Lists a site's sample URLs for crawl errors.}
\usage{
list_crawl_error_samples(siteURL, category = "notFound",
  platform = "web")
}
\arguments{
\item{siteURL}{The URL of the website to delete. Must include protocol (http://).}

\item{category}{Crawl error category. Default 'notFound'.}

\item{platform}{User agent type. Default 'web'.}
}
\value{
A dataframe of $pageUrl, $last_crawled, $first_detected, $response
}
\description{
Category is one of: authPermissions, manyToOneRedirect, notFollowed, notFound,
  other, roboted, serverError, soft404.

  Platform is one of: mobile, smartphoneOnly or web.
}
\details{
See here for details: \url{https://developers.google.com/webmaster-tools/v3/urlcrawlerrorssamples}
}
\seealso{
Other working with search console errors: \code{\link{crawl_errors}},
  \code{\link{error_sample_url}},
  \code{\link{fix_sample_url}}
}
\concept{working with search console errors}
