% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmi.R
\name{lmi2}
\alias{lmi2}
\title{Linear Matrix Inequality 2}
\usage{
lmi2(A1, A2, B)
}
\arguments{
\item{A1}{An nxm real valued matrix}

\item{A2}{An nxm real valued matrix}

\item{B}{An nxp real valued matrix}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{lmi2} creates input for sqlp to solve a linear matrix inequality problem
}
\details{
Solves the type-2 linear matrix inequality problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
A1 <- matrix(c(-1,0,1,0,-2,1,0,0,-1),3,3)
A2 <- A1 + 0.1*t(A1)
B  <- matrix(c(1,3,5,2,4,6),3,2)

out <- lmi2(A1,A2,B)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

