/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.sdols.featureallocation;

import java.io.Serializable;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.ddahl.commonsmath.package;
import org.ddahl.sdols.featureallocation.Feature;
import org.ddahl.sdols.featureallocation.Feature$;
import org.ddahl.sdols.featureallocation.FeatureAllocation;
import org.ddahl.sdols.featureallocation.FeatureAllocation$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.parallel.ParIterableLike;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class FeatureAllocationSummary$ {
    public static FeatureAllocationSummary$ MODULE$;

    static {
        new FeatureAllocationSummary$();
    }

    public <A> double[][] expectedPairwiseAllocationMatrix(Seq<FeatureAllocation<A>> fas) {
        if (fas.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        int nItems = ((FeatureAllocation)fas.head()).nItems();
        Array2DRowRealMatrix zero = package.MatrixFactory$.MODULE$.apply(nItems, nItems);
        return org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix((Array2DRowRealMatrix)((ParIterableLike)fas.par()).aggregate((Function0 & Serializable & scala.Serializable)() -> zero, (Function2 & Serializable & scala.Serializable)(sum, x) -> org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(sum).$plus(x.pairwiseAllocationMatrix()), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(x$1).$plus(x$2))).$colon$div((double)fas.size()).getData();
    }

    public <A> double sumOfSquaresSlow(FeatureAllocation<A> fa, double[][] pam) {
        return org.ddahl.commonsmath.package$.MODULE$.RichRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(fa.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x)).sum();
    }

    public <A> double sumOfAbsolutesSlow(FeatureAllocation<A> fa, double[][] pam) {
        return org.ddahl.commonsmath.package$.MODULE$.RichRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(fa.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x$3)))).sum();
    }

    private <A> double engine(int[][] counts, double[][] pam, Function1<Object, Object> f) {
        int nItems = pam.length;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < nItems; ++i) {
            int[] countsi = counts[i];
            double[] pami = pam[i];
            sum1 += f.apply$mcDD$sp((double)countsi[i] - pami[i]);
            for (int j = 0; j < i; ++j) {
                sum2 += f.apply$mcDD$sp((double)countsi[j] - pami[j]);
            }
        }
        return sum1 + (double)2 * sum2;
    }

    public <A> double sumOfSquares(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x);
    }

    public <A> double sumOfAbsolutes(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x)));
    }

    public <A> FeatureAllocation<A> minAmongDraws(Seq<FeatureAllocation<A>> candidates, int maxSize, boolean multicore, String loss, Option<double[][]> pamOption) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        double[][] pam = (double[][])pamOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.expectedPairwiseAllocationMatrix((Seq)candidates));
        Function2 lossEngine = this.getLoss(loss);
        GenSeq iter = multicore ? (GenSeq)candidates.par() : candidates;
        return (FeatureAllocation)iter.minBy((Function1 & Serializable & scala.Serializable)featureAllocation -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.$anonfun$minAmongDraws$2(maxSize, pam, lossEngine, featureAllocation)), (Ordering)Ordering.Double$.MODULE$);
    }

    private ListBuffer<FeatureAllocation<Null$>> expand(FeatureAllocation<Null$> fa, List<Feature<Null$>> availableFeatures, int i) {
        ListBuffer listBuffer;
        if (availableFeatures.isEmpty()) {
            listBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            FeatureAllocation<Null$> faPlus = fa.add(i, (Feature)availableFeatures.head());
            List tail = (List)availableFeatures.tail();
            listBuffer = tail.isEmpty() ? (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FeatureAllocation[]{fa, faPlus})) : (ListBuffer)this.expand(fa, (List<Feature<Null$>>)tail, i).$plus$plus(this.expand(faPlus, (List<Feature<Null$>>)tail, i));
        }
        return listBuffer;
    }

    private FeatureAllocation<Null$> padWithFeature(FeatureAllocation<Null$> fa, Feature<Null$> f, int nTimes) {
        FeatureAllocation<Null$> fa2 = fa;
        for (int j = 0; j < nTimes; ++j) {
            fa2 = fa2.add(f);
        }
        return fa2;
    }

    private FeatureAllocation<Null$> sequentiallyAllocatedLatentStructureOptimization(FeatureAllocation<Null$> initial, int maxSize, List<Object> permutation, double[][] pamTransform, Function2<FeatureAllocation<Null$>, double[][], Object> lossEngine) {
        int max = maxSize <= 0 ? Integer.MAX_VALUE : maxSize;
        ObjectRef fa = ObjectRef.create(initial);
        permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            FeatureAllocation featureAllocation;
            Feature<Object> singleton = Feature$.MODULE$.apply(null, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{i}));
            int expectedNumberOfFeatures = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(pamTransform[i][i]));
            if (((FeatureAllocation)fa$1.elem).isEmpty()) {
                featureAllocation = MODULE$.padWithFeature((FeatureAllocation)fa$1.elem, singleton, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(expectedNumberOfFeatures), max));
            } else {
                ListBuffer candidates = MODULE$.expand((FeatureAllocation)fa$1.elem, ((FeatureAllocation)fa$1.elem).toList(), i);
                int residualCapacity = maxSize - ((FeatureAllocation)fa$1.elem).nFeatures();
                ListBuffer candidates2 = residualCapacity > 0 ? (ListBuffer)candidates.map((Function1 & Serializable & scala.Serializable)fa2 -> MODULE$.padWithFeature((FeatureAllocation<Null$>)fa2, (Feature<Null$>)singleton, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(expectedNumberOfFeatures - fa2.nFeatures(i)), residualCapacity)), ListBuffer$.MODULE$.canBuildFrom()) : candidates;
                featureAllocation = (FeatureAllocation)candidates2.minBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$3(pamTransform, lossEngine, x$4)), (Ordering)Ordering.Double$.MODULE$);
            }
            fa$1.elem = featureAllocation;
        });
        return (FeatureAllocation)fa.elem;
    }

    private <A> Function2<FeatureAllocation<A>, double[][], Object> getLoss(String loss) {
        Function2 & Serializable & scala.Serializable intersect;
        String string = loss;
        if ("squaredError".equals(string)) {
            intersect = (Function2 & Serializable & scala.Serializable)(fa, pam) -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.MODULE$.sumOfSquares(fa, pam));
        } else if ("absoluteError".equals(string)) {
            intersect = (Function2 & Serializable & scala.Serializable)(fa, pam) -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.MODULE$.sumOfAbsolutes(fa, pam));
        } else {
            throw new MatchError((Object)string);
        }
        return intersect;
    }

    public Tuple3<FeatureAllocation<Null$>, Object, Object> sequentiallyAllocatedLatentStructureOptimization(int nCandidates, double budgetInSeconds, double[][] pam, int maxSize, boolean multicore, String loss) {
        Function2 lossEngine = this.getLoss(loss);
        Random rng = new Random();
        int nItems = pam.length;
        List ints = (List)List$.MODULE$.tabulate(nItems, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))));
        FeatureAllocation empty = FeatureAllocation$.MODULE$.empty(nItems);
        double budgetInMillis = budgetInSeconds <= 0.0 ? 9.223372036854776E18 : budgetInSeconds * (double)1000L;
        long start = System.currentTimeMillis();
        Range range = multicore ? package$.MODULE$.Range().apply(0, nCandidates) : package$.MODULE$.Range().apply(0, nCandidates);
        IndexedSeq candidates = (IndexedSeq)((TraversableLike)range.map((Function1 & Serializable & scala.Serializable)i -> FeatureAllocationSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$5(pam, maxSize, lossEngine, rng, ints, empty, budgetInMillis, start, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FeatureAllocationSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$6(x$5)));
        return new Tuple3(candidates.minBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$7(pam, lossEngine, x$6)), (Ordering)Ordering.Double$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)candidates.size()));
    }

    public static final /* synthetic */ double $anonfun$minAmongDraws$2(int maxSize$1, double[][] pam$1, Function2 lossEngine$1, FeatureAllocation featureAllocation) {
        return maxSize$1 > 0 && featureAllocation.size() > maxSize$1 ? Double.POSITIVE_INFINITY : BoxesRunTime.unboxToDouble((Object)lossEngine$1.apply((Object)featureAllocation, (Object)pam$1));
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$3(double[][] pamTransform$1, Function2 lossEngine$2, FeatureAllocation x$4) {
        return BoxesRunTime.unboxToDouble((Object)lossEngine$2.apply((Object)x$4, (Object)pamTransform$1));
    }

    public static final /* synthetic */ FeatureAllocation $anonfun$sequentiallyAllocatedLatentStructureOptimization$5(double[][] pam$2, int maxSize$3, Function2 lossEngine$3, Random rng$1, List ints$1, FeatureAllocation empty$1, double budgetInMillis$1, long start$1, int i) {
        List permutation = (List)rng$1.shuffle((TraversableOnce)ints$1, List$.MODULE$.canBuildFrom());
        return (double)(System.currentTimeMillis() - start$1) <= budgetInMillis$1 ? MODULE$.sequentiallyAllocatedLatentStructureOptimization(empty$1, maxSize$3, (List<Object>)permutation, pam$2, (Function2<FeatureAllocation<Null$>, double[][], Object>)lossEngine$3) : null;
    }

    public static final /* synthetic */ boolean $anonfun$sequentiallyAllocatedLatentStructureOptimization$6(FeatureAllocation x$5) {
        return x$5 != null;
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$7(double[][] pam$2, Function2 lossEngine$3, FeatureAllocation x$6) {
        return BoxesRunTime.unboxToDouble((Object)lossEngine$3.apply((Object)x$6, (Object)pam$2));
    }

    private FeatureAllocationSummary$() {
        MODULE$ = this;
    }
}

