% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sdcProcessCells}
\alias{identifyBigCellRecords}
\alias{identifyBigCells}
\alias{identifySmallCellRecords}
\alias{identifySmallCells}
\alias{removeBigCellRecords}
\alias{removeSmallCellRecords}
\alias{sdcProcessCells}
\title{Identify or Remove Small or Large Cells From a Hash List}
\usage{
identifySmallCells(Y, cutoff = 1)

identifyBigCells(Y, cutoff = 1)

identifySmallCellRecords(Y, cutoff = 1)

identifyBigCellRecords(Y, cutoff = 1)

removeSmallCellRecords(X, Y, cutoff = 1)

removeBigCellRecords(X, Y, cutoff = 1)
}
\arguments{
\item{Y}{A hash list as returned by \code{\linkS4class{sdcHashClass}}.}

\item{cutoff}{The lower or upper cutoff of cell size.}

\item{X}{A data frame corresponding to \code{Y}.}
}
\description{
Returns a hash list identifying the appropriate cells, or a
  subset of the data provided with the specified cells removed.
}
\examples{
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.hc <- new("sdcHashClass", X = my.X)
identifySmallCells(my.hc)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.hc <- new("sdcHashClass", X = my.X)
identifyBigCells(my.hc)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.hc <- new("sdcHashClass", X = my.X)
identifySmallCellRecords(my.hc)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.hc <- new("sdcHashClass", X = my.X)
identifyBigCellRecords(my.hc)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.hc <- new("sdcHashClass", X = my.X)
removeSmallCellRecords(my.X, my.hc)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.hc <- new("sdcHashClass", X = my.X)
removeBigCellRecords(my.X, my.hc)
}
\seealso{
\code{\linkS4class{sdcHashClass}},
}
\keyword{big}
\keyword{cells,}
\keyword{identify,}
\keyword{remove}
\keyword{small}

