% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeJJFormat.R
\name{writeJJFormat}
\alias{writeJJFormat}
\title{Write a problem in jj-format to a file}
\usage{
writeJJFormat(x, tabvar = "freqs", path = "out.jj", overwrite = FALSE)
}
\arguments{
\item{x}{an input produced by \code{\link[=createJJFormat]{createJJFormat()}}}

\item{tabvar}{the name of the variable that will be used when producing the
problem in JJ format. It is possible to specify \code{freqs} (the default) or the
name of a numeric variable that was available in the \linkS4class{sdcProblem} object
used in \code{\link[=makeProblem]{makeProblem()}}.}

\item{path}{a scalar character defining the name of the file that
should be written. This can be an absolute or relative URL; however the file
must not exist.}

\item{overwrite}{logical scalar, if \code{TRUE} the file specified in \code{path} will
be overwritten if it exists}
}
\value{
invisibly the path to the file that was created.
}
\description{
This function allows to write a problem instance in
JJ-Format to a file.
}
\examples{
# setup example problem
# microdata
utils::data("microdata1", package = "sdcTable")

# create hierarchies
dims <- list(
  region = sdcHierarchies::hier_create(root = "Total", nodes = LETTERS[1:4]),
  gender = sdcHierarchies::hier_create(root = "Total", nodes = c("male", "female")))

# create a problem instance
p <- makeProblem(
  data = microdata1,
  dimList = dims,
  numVarInd = "val")

# create suitable input for `writeJJFormat`
inp <- createJJFormat(p); inp

# write files to disk
# frequency table by default
writeJJFormat(
  x = inp,
  path = file.path(tempdir(), "prob_freqs.jj"),
  overwrite = TRUE
)

# or using the numeric variable `val` previously specified
writeJJFormat(
  x = inp,
  tabvar = "val",
  path = file.path(tempdir(), "prob_val.jj"),
  overwrite = TRUE
)
}
