% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_risk.R
\name{measure_risk}
\alias{measure_risk}
\alias{ldiversity}
\alias{print.measure_risk}
\alias{print.ldiversity}
\title{Disclosure Risk for Categorical Variables}
\usage{
measure_risk(obj, ...)

ldiversity(obj, ldiv_index = NULL, l_recurs_c = 2, missing = -999, ...)

\method{print}{measure_risk}(x, ...)

\method{print}{ldiversity}(x, ...)
}
\arguments{
\item{obj}{Object of class \code{\link{sdcMicroObj-class}}}

\item{...}{see arguments below
\itemize{
\item{data: }{Input data, a data.frame.}
\item{keyVars: }{names (or indices) of categorical key variables (for data-frame method)}
\item{w: }{name of variable containing sample weights}
\item{hid: }{name of the clustering variable, e.g. the household ID}
\item{max_global_risk: }{Maximal global risk for threshold computation}
\item{fast_hier: }{If TRUE a fast approximation is computed if household data are provided.}
}}

\item{ldiv_index}{indices (or names) of the variables used for l-diversity}

\item{l_recurs_c}{l-Diversity Constant}

\item{missing}{a integer value to be used as missing value in the C++ routine}

\item{x}{Output of measure_risk() or ldiversity()}
}
\value{
A modified \code{\link{sdcMicroObj-class}} object or a list with the following elements:
\itemize{
\item{global_risk_ER: }{expected number of re-identification.}
\item{global_risk: }{global risk (sum of indivdual risks).}
\item{global_risk_pct: }{global risk in percent.}
\item{Res: }{matrix with the risk, frequency in the sample and grossed-up frequency in the population (and the hierachical risk) for each observation.}
\item{global_threshold: }{for a given max_global_risk the threshold for the risk of observations.}
\item{max_global_risk: }{the input max_global_risk of the function.}
\item{hier_risk_ER: }{expected number of re-identification with household structure.}
\item{hier_risk: }{global risk with household structure (sum of indivdual risks).}
\item{hier_risk_pct: }{global risk with household structure in percent.}
\item{ldiverstiy: }{Matrix with Distinct_Ldiversity,
Entropy_Ldiversity and Recursive_Ldiversity for each sensitivity variable.}}

Prints risk-information into the console

Information on L-Diversity Measures in the console
}
\description{
The function measures the disclosure risk for weighted or unweighted data.
It computes the individual risk (and household risk if reasonable) and the
global risk. It also computes a risk threshold based on a global risk value.

Prints a 'measure_risk'-object

Prints a 'ldiversity'-object
}
\details{
To be used when risk of disclosure for individuals within a family is
considered to be statistical independent.

Internally, function \emph{freqCalc()} and \emph{indivRisk} are used for
estimation.

Measuring individual risk: The individual risk approach based on so-called
super-population models. In such models population frequency counts are
modeled given a certain distribution.  The estimation procedure of sample
frequency counts given the population frequency counts is modeled by
assuming a negative binomial distribution. This is used for the estimation
of the individual risk. The extensive theory can be found in Skinner (1998),
the approximation formulas for the individual risk used is described in
Franconi and Polettini (2004).

Measuring hierarchical risk: If \dQuote{hid} - the index of variable holding
information on the hierarchical cluster structures (e.g., individuals that
are clustered in households) - is provided, the hierarchical risk is
additional estimated.  Note that the risk of re-identifying an individual
within a household may also affect the probability of disclosure of other
members in the same household. Thus, the household or cluster-structure of
the data must be taken into account when estimating disclosure risks. It is
commonly assumed that the risk of re-identification of a household is the
risk that at least one member of the household can be disclosed. Thus this
probability can be simply estimated from individual risks as 1 minus the
probability that no member of the household can be identified.

Global risk: The sum of the individual risks in the dataset gives the
expected number of re-identifications that serves as measure of the global
risk.

l-Diversity: If \dQuote{ldiv_index} is unequal to NULL, i.e. if the indices
of sensible variables are specified, various measures for l-diversity are
calculated. l-diverstiy is an extension of the well-known k-anonymity
approach where also the uniqueness in sensible variables for each pattern
spanned by the key variables are evaluated.
}
\examples{
## measure_risk with sdcMicro objects:
data(testdata)
sdc <- createSdcObj(testdata,
  keyVars=c('urbrur','roof','walls','water','electcon'),
numVars=c('expend','income','savings'), w='sampling_weight')

## risk is already estimated and available in...
names(sdc@risk)

## measure risk on data frames or matrices:
res <- measure_risk(testdata,
  keyVars=c("urbrur","roof","walls","water","sex"))
print(res)
head(res$Res)
resw <- measure_risk(testdata,
  keyVars=c("urbrur","roof","walls","water","sex"),w="sampling_weight")
print(resw)
head(resw$Res)
res1 <- ldiversity(testdata,
  keyVars=c("urbrur","roof","walls","water","sex"),ldiv_index="electcon")
print(res1)
head(res1)
res2 <- ldiversity(testdata,
  keyVars=c("urbrur","roof","walls","water","sex"),ldiv_index=c("electcon","relat"))
print(res2)
head(res2)

# measure risk with household risk
resh <- measure_risk(testdata,
  keyVars=c("urbrur","roof","walls","water","sex"),w="sampling_weight",hid="ori_hid")
print(resh)

# change max_global_risk
rest <- measure_risk(testdata,
  keyVars=c("urbrur","roof","walls","water","sex"),
  w="sampling_weight",max_global_risk=0.0001)
print(rest)

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
## -> when using `createSdcObj()`, the risks are already internally computed
## and it is not required to explicitely run `sdc <- measure_risk(sdc)`
}
\references{
Franconi, L. and Polettini, S. (2004) \emph{Individual risk
estimation in mu-Argus: a review}. Privacy in Statistical Databases, Lecture
Notes in Computer Science, 262--272. Springer

Machanavajjhala, A. and Kifer, D. and Gehrke, J. and Venkitasubramaniam, M.
(2007) \emph{l-Diversity: Privacy Beyond k-Anonymity}.  ACM Trans. Knowl.
Discov. Data, 1(1)

Templ, M. Statistical Disclosure Control for Microdata: Methods and Applications in R.
\emph{Springer International Publishing}, 287 pages, 2017. ISBN 978-3-319-50272-4.
\doi{10.1007/978-3-319-50272-4}.

#' Templ, M. and Kowarik, A. and Meindl, B.
Statistical Disclosure Control for Micro-Data Using the R Package sdcMicro.
\emph{Journal of Statistical Software}, \strong{67} (4), 1--36, 2015. \doi{10.18637/jss.v067.i04}
}
\seealso{
\code{\link{freqCalc}}, \code{\link{indivRisk}}

\code{\link{measure_risk}}
}
\author{
Alexander Kowarik, Bernhard Meindl, Matthias Templ, Bernd Prantner, minor parts of IHSN C++ source
}
\keyword{manip}
\keyword{print}
