### R code from vignette source 'intro.Rnw'

###################################################
### code chunk number 1: intro.Rnw:20-23
###################################################
library(scuba)
sversion <- read.dcf(file = system.file("DESCRIPTION", package = "scuba"),
         fields = "Version")


###################################################
### code chunk number 2: intro.Rnw:59-65
###################################################
opa <- par(mfrow=c(1,2))
d1 <- dive(c(20,20), c(5,5))
data(pedro)
plot(d1, main="", lwd=4)
plot(pedro950, main="")
par(opa)


###################################################
### code chunk number 3: intro.Rnw:84-85
###################################################
d <- dive(c(18,45))


###################################################
### code chunk number 4: intro.Rnw:102-104
###################################################
d <- dive(c(18,45))
haldane(d)


###################################################
### code chunk number 5: intro.Rnw:119-123
###################################################
data(pedro)
frag <- chop.dive(pedro902, 0, 35)
hald <- haldane(frag, relative=TRUE, model="Z")
otu  <- oxtox(frag)


###################################################
### code chunk number 6: intro.Rnw:126-140
###################################################
opa <- par(mfrow=c(1,2))
pozzie <- barplot(hald,
                  xlab=paste("Tissues (ZH-L16A)", sep=""),
                  ylab="Relative saturation",
                  main=paste("Time= 35 min\n",
                    "Accumulated oxygen toxicity", round(otu, 1)),
                      ylim=range(c(0, 1.1, 1.1 * max(hald))),
                      names.arg=NULL)
mtext(side=1, at=pozzie[1], line=1, text="Fast")
mtext(side=1, at=pozzie[17], line=1, text="Slow")
abline(h=1, lty=3, col="red")
plot(pedro902)
abline(v=35, lty=2, col="green")
par(opa)


###################################################
### code chunk number 7: intro.Rnw:149-150
###################################################
hald902 <- haldane(pedro902, progressive=TRUE, relative=TRUE)


###################################################
### code chunk number 8: intro.Rnw:152-155
###################################################
persp(times.dive(pedro902), 1:8, hald902,
      theta=-45, shade=0.5, col="yellow", border=NA,
      xlab="Time", ylab="Tissue", zlab="Relative saturation")


###################################################
### code chunk number 9: intro.Rnw:163-164
###################################################
ndl(24)


###################################################
### code chunk number 10: intro.Rnw:175-177
###################################################
nitrox(0.32)
nitrox(1)


###################################################
### code chunk number 11: intro.Rnw:183-184
###################################################
ndl(24, nitrox(0.32))


###################################################
### code chunk number 12: intro.Rnw:189-191
###################################################
g <- nitrox(0.32)
ndl(24, g)


###################################################
### code chunk number 13: intro.Rnw:199-200
###################################################
mod(nitrox(0.32))


###################################################
### code chunk number 14: intro.Rnw:208-209
###################################################
nd <- dive(nitrox(0.32), c(18, 45))


###################################################
### code chunk number 15: intro.Rnw:219-222
###################################################
d <- dive(trimix(0.18, 0.45), c(40, 20), c(30,10), 9, nitrox(0.6), 
        c(9,3), c(6, 5), c(3, 11))
plot(d)


###################################################
### code chunk number 16: intro.Rnw:246-247
###################################################
detach("package:scuba")


###################################################
### code chunk number 17: intro.Rnw:250-251
###################################################
library(scuba)


###################################################
### code chunk number 18: intro.Rnw:321-322
###################################################
d <- dive(c(18, 45), c(5,3))


###################################################
### code chunk number 19: intro.Rnw:329-330
###################################################
plot(d)


###################################################
### code chunk number 20: intro.Rnw:336-337
###################################################
d


###################################################
### code chunk number 21: intro.Rnw:344-345
###################################################
summary(d)


###################################################
### code chunk number 22: intro.Rnw:369-370
###################################################
d2 <- dive(c(18, 45), c(5,3))


###################################################
### code chunk number 23: intro.Rnw:376-378
###################################################
plot(d2)
d2


###################################################
### code chunk number 24: intro.Rnw:386-387
###################################################
d3 <- dive(c(30,15),c(9,1),c(5,5),c(0,60),c(12,60),c(5,5))


###################################################
### code chunk number 25: intro.Rnw:393-394
###################################################
plot(d3)


###################################################
### code chunk number 26: intro.Rnw:451-452 (eval = FALSE)
###################################################
## mydata <- read.table("myfile.txt", header=TRUE, as.is=TRUE)


###################################################
### code chunk number 27: intro.Rnw:454-456
###################################################
data(baron)
mydata <- baron


###################################################
### code chunk number 28: intro.Rnw:485-486
###################################################
head(mydata)


###################################################
### code chunk number 29: intro.Rnw:492-493
###################################################
mydf <- mydata[ , 1:2]


###################################################
### code chunk number 30: intro.Rnw:498-500
###################################################
head(mydf)
is.character(mydf[,1])


###################################################
### code chunk number 31: intro.Rnw:511-512
###################################################
d <- dive(mydf)


###################################################
### code chunk number 32: intro.Rnw:521-522
###################################################
d <- dive(mydf, begin=NA, end=NA)


###################################################
### code chunk number 33: intro.Rnw:530-533
###################################################
data(baron)
mydf <- baron[, 1:2]
baronprof <- dive(mydf[,1:2])


###################################################
### code chunk number 34: intro.Rnw:545-547
###################################################
data(pedro)
plot(pedro902)


###################################################
### code chunk number 35: intro.Rnw:567-570
###################################################
d <- dive(c(30, 20), c(5, 3))
depths.dive(d)
times.dive(d)


###################################################
### code chunk number 36: intro.Rnw:579-581
###################################################
depths.dive(d) <- c(0, 35, 35, 5, 5, 0)
d


###################################################
### code chunk number 37: intro.Rnw:587-588
###################################################
depths.dive(d)[2:3] <- 35


###################################################
### code chunk number 38: intro.Rnw:601-602
###################################################
durations.dive(d)[2] <- 25


###################################################
### code chunk number 39: intro.Rnw:611-612
###################################################
chop.dive(d, 0, 10)


###################################################
### code chunk number 40: intro.Rnw:623-625
###################################################
data(pedro)
plot(pedro902)


###################################################
### code chunk number 41: intro.Rnw:632-636
###################################################
tim <- times.dive(pedro902)
dep <- depths.dive(pedro902)
t9 <- max(tim[dep >= 9])
t9


###################################################
### code chunk number 42: intro.Rnw:643-645
###################################################
before <- chop.dive(pedro902, 0, t9)
after <- chop.dive(pedro902, t9)


###################################################
### code chunk number 43: intro.Rnw:650-652
###################################################
newdive <- dive(before, c(9, 5), after)
plot(newdive)


###################################################
### code chunk number 44: intro.Rnw:698-700
###################################################
m <- pickmodel("USN")
m


###################################################
### code chunk number 45: intro.Rnw:713-714
###################################################
ndl(30, model="USN")


###################################################
### code chunk number 46: intro.Rnw:727-728
###################################################
bestdoubledive(40, 12, 15)


###################################################
### code chunk number 47: intro.Rnw:747-749
###################################################
d <- dive(c(18,60), c(5,5))
haldane(d)


###################################################
### code chunk number 48: intro.Rnw:760-761
###################################################
haldane(d, relative=TRUE)


###################################################
### code chunk number 49: intro.Rnw:771-779 (eval = FALSE)
###################################################
## data(pedro)
## h <- haldane(pedro902, progressive=TRUE, relative=TRUE)
## tim <- times.dive(pedro902)
## tiss <- row.names(as.data.frame(pickmodel("D")))
## ntiss <- length(tiss)
## image(tim, 1:ntiss, h, xlab="Time", ylab="Tissue", axes=FALSE)
## axis(1)
## axis(2, at=1:ntiss, labels=tiss)


###################################################
### code chunk number 50: intro.Rnw:781-787
###################################################
tim <- times.dive(pedro902)
tiss <- row.names(as.data.frame(pickmodel("D")))
ntiss <- length(tiss)
image(tim, 1:ntiss, hald902, xlab="Time", ylab="Tissue", axes=FALSE)
axis(1)
axis(2, at=1:ntiss, labels=tiss)


###################################################
### code chunk number 51: intro.Rnw:793-796 (eval = FALSE)
###################################################
## persp(tim, 1:ntiss, h,
##       theta=-45, shade=0.5, col="yellow", border=NA,
##       xlab="Time", ylab="Tissue", zlab="Relative saturation")


###################################################
### code chunk number 52: intro.Rnw:798-801
###################################################
persp(tim, 1:ntiss, hald902,
      theta=-45, shade=0.5, col="yellow", border=NA,
      xlab="Time", ylab="Tissue", zlab="Relative saturation")


###################################################
### code chunk number 53: intro.Rnw:813-827
###################################################
opa <- par(mfrow=c(1,2))
pozzie <- barplot(hald,
                  xlab=paste("Tissues (ZH-L16A)", sep=""),
                  ylab="Relative saturation",
                  main=paste("Time= 35 min\n",
                    "Accumulated oxygen toxicity", round(otu, 1)),
                      ylim=range(c(0, 1.1, 1.1 * max(hald))),
                      names.arg=NULL)
mtext(side=1, at=pozzie[1], line=1, text="Fast")
mtext(side=1, at=pozzie[17], line=1, text="Slow")
abline(h=1, lty=3, col="red")
plot(pedro902)
abline(v=35, lty=2, col="green")
par(opa)


###################################################
### code chunk number 54: intro.Rnw:843-845
###################################################
p <- ppO2(pedro902)
plot(p, type="l", ylab="PPO2 (atm)")


###################################################
### code chunk number 55: intro.Rnw:851-852
###################################################
oxtox(pedro902)


###################################################
### code chunk number 56: intro.Rnw:874-877
###################################################
nitrox(0.36)
nitrox(1)
nitrox(0.21)


###################################################
### code chunk number 57: intro.Rnw:886-887
###################################################
trimix(0.18, 0.45)


###################################################
### code chunk number 58: intro.Rnw:894-895
###################################################
summary(nitrox(0.36))


###################################################
### code chunk number 59: intro.Rnw:911-912
###################################################
ead(24, nitrox(0.32))


###################################################
### code chunk number 60: intro.Rnw:919-920
###################################################
mod(nitrox(0.36), 1.5)


###################################################
### code chunk number 61: intro.Rnw:926-927
###################################################
maxmix(40, 1.5)


###################################################
### code chunk number 62: intro.Rnw:935-936
###################################################
END(40, trimix(0.18,0.5))


###################################################
### code chunk number 63: intro.Rnw:958-959
###################################################
dive(nitrox(0.32), c(30,20))


###################################################
### code chunk number 64: intro.Rnw:967-968
###################################################
dive(c(30,20), 5, nitrox(0.36), c(5,3))


###################################################
### code chunk number 65: intro.Rnw:995-997
###################################################
dive(nitrox(0.25), c(30, 20), c(5,3), c(0, 20))
dive(nitrox(0.25), c(30, 20), c(5,3), 0, air, c(0, 20))


###################################################
### code chunk number 66: intro.Rnw:1012-1013
###################################################
d <- dive(c(30,20), c(5,5))


###################################################
### code chunk number 67: intro.Rnw:1020-1021
###################################################
tanklist(d) <- list(nitrox(0.32))


###################################################
### code chunk number 68: intro.Rnw:1028-1029
###################################################
d <- dive(air, c(30,40), 6, nitrox(0.5), c(6,3), c(3,3))


###################################################
### code chunk number 69: intro.Rnw:1035-1036
###################################################
tanklist(d) <- list(nitrox(0.32), nitrox(0.5))


###################################################
### code chunk number 70: intro.Rnw:1042-1043
###################################################
tanklist(d)[[1]] <- nitrox(0.32)


###################################################
### code chunk number 71: intro.Rnw:1050-1051
###################################################
tanklist(d) <- list(deep=nitrox(0.32), deco=nitrox(0.5))


###################################################
### code chunk number 72: intro.Rnw:1057-1058
###################################################
names(tanklist(d)) <- c("deep", "deco")


###################################################
### code chunk number 73: intro.Rnw:1068-1071
###################################################
TL <- list(travel=trimix(0.18, 0.45), deco=nitrox(0.6))
d <- dive(tanklist=TL, tank="travel", c(30,40), 6, 
            tank="deco", c(6,3), c(3,3))


###################################################
### code chunk number 74: intro.Rnw:1087-1088
###################################################
whichtank(d)


###################################################
### code chunk number 75: intro.Rnw:1096-1097
###################################################
whichtank(d) <- ifelse(depths.dive(d) < 3, "travel", "deco")


###################################################
### code chunk number 76: intro.Rnw:1103-1104
###################################################
whichtank(d)[depths.dive(d) > 3] <- "travel"


###################################################
### code chunk number 77: intro.Rnw:1113-1116
###################################################
b <- dive(baron[,1:2])
tanklist(b) <- list(travel=air, deco=nitrox(0.36))
whichtank(b) <- ifelse(times.dive(b) <= 32, "travel", "deco")


###################################################
### code chunk number 78: intro.Rnw:1125-1129
###################################################
tanklist(b) <- list(travel=air, deco=nitrox(0.32), rich=nitrox(0.5))
whichtank(b) <- "travel"
whichtank(b)[times.dive(b) > 32] <- "deco"
whichtank(b)[times.dive(b) > 37] <- "rich"


###################################################
### code chunk number 79: intro.Rnw:1134-1136
###################################################
whichtank(b) <- cut(times.dive(b), breaks=c(0, 32, 37, Inf),
                    include.lowest=TRUE, labels=c("travel", "deco", "rich"))


