% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit-special}
\alias{audit-special}
\alias{audit_seq}
\alias{audit_total_n}
\title{Summarize output of sequence mappers and total-n mappers}
\usage{
audit_seq(data)

audit_total_n(data)
}
\arguments{
\item{data}{A data frame that inherits one of the classes named below.}
}
\value{
A tibble (data frame) with test summary statistics.
}
\description{
\code{audit_seq()} and \code{audit_total_n()} summarize the results of
functions that end on \verb{_seq} and \verb{_total_n}, respectively.

See below for a record of such functions. Go to the documentation of any of
them to learn about the way its output is processed by \code{audit_seq()} or
\code{audit_total_n()}.
}
\details{
All functions named below that end on \verb{_seq} were made by
\code{function_map_seq()}. All that end on \verb{_total_n} were made by
\code{function_map_total_n()}.
}
\section{Before \code{audit_seq()}}{
\tabular{ll}{
   \strong{Function} \tab \strong{Class} \cr
   \code{grim_map_seq()} \tab \code{"scr_grim_map_seq"} \cr
   \code{grimmer_map_seq()} \tab \code{"scr_grimmer_map_seq"} \cr
   \code{debit_map_seq()} \tab \code{"scr_debit_map_seq"} \cr
}
}

\section{Before \code{audit_total_n()}}{
\tabular{ll}{
   \strong{Function} \tab \strong{Class} \cr
   \code{grim_map_total_n()} \tab \code{"scr_grim_map_total_n"} \cr
   \code{grimmer_map_total_n()} \tab \code{"scr_grimmer_map_total_n"} \cr
   \code{debit_map_total_n()} \tab \code{"scr_debit_map_total_n"} \cr
}
}

\examples{
# For GRIM-testing with dispersed inputs:
out <- pigs1 \%>\%
  grim_map_seq() \%>\%
  audit_seq()
out

# Follow up on `audit_seq()` or
# `audit_total_n()` with `audit()`:
audit(out)
}
