% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{set_gt_conc}
\alias{set_gt_conc}
\title{Cell-distribution variability upon phasing}
\usage{
set_gt_conc(acset)
}
\arguments{
\item{acset}{An acset list created by \code{\link{new_acset}}. The acset must
contain an element 'gt', see \code{\link{call_gt}} and an element
'gt_phased', see function \code{\link{phase}}.}
}
\value{
acset An acset list where two elements have been added or updated,
'gt_conc' and 'gt_phased_conc'. The elements contain the concordance and
inconcordance for every gene before (gt_conc) and after phasing
(gt_phased_conc).
}
\description{
\code{set_gt_conc} calculates an approximate measure of the spread of the
cells in the allele-specific expression variant-space per gene
}
\details{
To assess the success of the phasing one can calculate the degree of
variability remaining if all cells with haplotype 2 are set to haplotype 1.
As a rough measure of this this function calculates the variability as the
number of cells that differ from the inferred haplotype for every gene with
two variants. The differing number of cells per gene we denote as the
inconcordance and the number of cells with identical haplotype to the
inferred haplotype as concordance. This can be understood by viewing each
cell as a point in a transcribed genotype variant space, where each dimension
is a variant (within a gene), with values in the transcribed genotype domain.
The expression of the alleles within a gene from a single cell will then tend
to cluster towards the haplotype state, and the remaining variability of the
cells in that space after phasing can be used to measure how well the cells
conform to the haplotype.
}
\examples{
##load dataset
invisible(marinov)
acset = new_acset(featdata = marinov[['featdata']], refcount =
marinov[['refcount']], altcount = marinov[['altcount']], phenodata =
marinov[['phenodata']])

##Call gt
acset = call_gt(acset, min_acount = 3, fc = 3)

##Filter variants and genes
acset = filter_acset(acset, nmincells = 5, nminvar = 2)

##Phase
acset = phase(acset, input = 'gt', weigh = FALSE, method = 'exhaust')

##Get genotype concordance before and after phasing
acset = set_gt_conc(acset)

}

