% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-quantile.R
\name{get_metrics.forecast_quantile}
\alias{get_metrics.forecast_quantile}
\title{Get default metrics for quantile-based forecasts}
\usage{
\method{get_metrics}{forecast_quantile}(x, select = NULL, exclude = NULL, ...)
}
\arguments{
\item{x}{A forecast object (a validated data.table with predicted and
observed values, see \code{\link[=as_forecast_binary]{as_forecast_binary()}}).}

\item{select}{A character vector of scoring rules to select from the list. If
\code{select} is \code{NULL} (the default), all possible scoring rules are returned.}

\item{exclude}{A character vector of scoring rules to exclude from the list.
If \code{select} is not \code{NULL}, this argument is ignored.}

\item{...}{unused}
}
\description{
For quantile-based forecasts, the default scoring rules are:
\itemize{
\item "wis" = \code{\link[=wis]{wis()}}
\item "overprediction" = \code{\link[=overprediction_quantile]{overprediction_quantile()}}
\item "underprediction" = \code{\link[=underprediction_quantile]{underprediction_quantile()}}
\item "dispersion" = \code{\link[=dispersion_quantile]{dispersion_quantile()}}
\item "bias" = \code{\link[=bias_quantile]{bias_quantile()}}
\item "interval_coverage_50" = \code{\link[=interval_coverage]{interval_coverage()}}
\item "interval_coverage_90" = purrr::partial(
interval_coverage, interval_range = 90
)
\item "ae_median" = \code{\link[=ae_median_quantile]{ae_median_quantile()}}
}

Note: The \code{interval_coverage_90} scoring rule is created by modifying
\code{\link[=interval_coverage]{interval_coverage()}}, making use of the function \code{\link[purrr:partial]{purrr::partial()}}.
This construct allows the function to deal with arbitrary arguments in \code{...},
while making sure that only those that \code{\link[=interval_coverage]{interval_coverage()}} can
accept get passed on to it. \code{interval_range = 90} is set in the function
definition, as passing an argument \code{interval_range = 90} to \code{\link[=score]{score()}} would
mean it would also get passed to \code{interval_coverage_50}.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-quantile.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for quantile-based forecasts
}
\if{latex}{
  \figure{metrics-quantile.png}
}
}

\examples{
get_metrics(example_quantile, select = "wis")
}
\seealso{
Other get_metrics functions: 
\code{\link{get_metrics}()},
\code{\link{get_metrics.forecast_binary}()},
\code{\link{get_metrics.forecast_nominal}()},
\code{\link{get_metrics.forecast_ordinal}()},
\code{\link{get_metrics.forecast_point}()},
\code{\link{get_metrics.forecast_sample}()},
\code{\link{get_metrics.scores}()}
}
\concept{get_metrics functions}
\keyword{handle-metrics}
