#' @title scoringutils
#'
#' @description
#' This package is designed to help with assessing the quality of predictions.
#' It provides a collection of proper scoring rules and metrics as well that
#' can be accessed independently or collectively through a higher-level wrapper
#' function.
#'
#' Predicitions can be either probabilistic forecasts (generally predictive
#' samples generated by Markov Chain Monte Carlo procedures), quantile
#' forecasts or point forecasts. The true values can be either continuous,
#' integer, or binary.
#'
#' A collection of different metrics and scoring rules can be accessed through
#' the function \code{\link{eval_forecasts}}. Given a data.frame of the
#' correct form the function will automatically figure out the type of
#' prediction and true values and return appropriate scoring metrics.
#'
#' The package also has a lot of default visualisation based on the output
#' created by \code{\link{eval_forecasts}}.
#'
#' \itemize{
#' \item \code{\link{score_table}}
#' \item \code{\link{correlation_plot}}
#' \item \code{\link{wis_components}}
#' \item \code{\link{range_plot}}
#' \item \code{\link{score_heatmap}}
#' \item \code{\link{plot_predictions}}
#' \item \code{\link{interval_coverage}}
#' \item \code{\link{quantile_coverage}}
#' }
#'
#' Alternatively, the following functions can be accessed directly:
#'
#' \itemize{
#' \item \code{\link{brier_score}}
#' \item \code{\link{pit}}
#' \item \code{\link{bias}}
#' \item \code{\link{quantile_bias}}
#' \item \code{\link{sharpness}}
#' \item \code{\link{crps}}
#' \item \code{\link{logs}}
#' \item \code{\link{dss}}
#' \item \code{\link{ae_median}}
#' }
#'
#' Predictions can be evaluated in a lot of differnent formats. If you want to
#' convert from one format to the other, the following helper functions can
#' do that for you:
#'
#' \itemize{
#' \item \code{\link{sample_to_range}}
#' \item \code{\link{sample_to_quantile}}
#' \item \code{\link{quantile_to_range}}
#' \item \code{\link{range_to_quantile}}
#' }
#'
#' @docType package
#' @name scoringutils

NULL
